package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import java.util.List;
import lombok.Data;

/**
 * 获取封面影像Request
 *
 * @author rongying
 * @date 2021/5/17 10:00
 */
@ApiModel(description = "移动端上传处理Request")
@JsonInclude(NON_NULL)
@Data
public class MobileUploadHandleRequest extends BaseRequest {

    /**
     * 影像信息集合
     */
    private List<FileDTO> imageList;

    /**
     * 上传类型 1 - base64;2 - 微信ID
     */
    private String uploadType;

}
