package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 单据重算request
 */
@ApiModel(description = "单据重算request")

@JsonInclude(NON_NULL)
public class ReCheckBillRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonIgnore
    public ReCheckBillRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code集合")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReCheckBillRequest reCheckBillRequest = (ReCheckBillRequest) o;
        return Objects.equals(this.billCode, reCheckBillRequest.billCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReCheckBillRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
