package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 个人单证提交
 */
@ApiModel(description = "个人单证提交")

@JsonInclude(NON_NULL)
public class SubmitTicketRequest extends BaseRequest {

    @JsonProperty("imageIds")
    private List<Long> imageIds = new ArrayList<Long>();

    private String backRemark;

    /**
     * 0或者空，默认提交，1-无需退回
     */
    private Integer type;

    @JsonIgnore
    public SubmitTicketRequest imageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
        return this;
    }

    public SubmitTicketRequest addImageIdsItem(Long imageIdsItem) {
        this.imageIds.add(imageIdsItem);
        return this;
    }

    /**
     * imageId数组列表
     *
     * @return imageIds
     **/
    @ApiModelProperty(value = "imageId数组列表")
    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SubmitTicketRequest submitTicketRequest = (SubmitTicketRequest) o;
        return Objects.equals(this.imageIds, submitTicketRequest.imageIds) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageIds, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmitTicketRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageIds: ").append(toIndentedString(imageIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getBackRemark() {
        return backRemark;
    }

    public void setBackRemark(String backRemark) {
        this.backRemark = backRemark;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

}
