package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.CheckBillBackReScanRequest;
import com.xforceplus.elephant.image.client.model.CheckBillImageRequest;
import com.xforceplus.elephant.image.client.model.CheckBillTicketRequest;
import com.xforceplus.elephant.image.client.model.CheckSaveCommitTicketRequest;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "checkBill", description = "the checkBill API", tags = "checkBill")
public interface CheckBillApi {

    @ApiOperation(value = "校验岗单据退回重扫", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/backReScan",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse backReScan(@ApiParam(value = "request", required = true) @Valid CheckBillBackReScanRequest request
    );


    @ApiOperation(value = "校验岗单据退回重扫单张影像", notes = "校验岗单据退回重扫单张影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/backReScanImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse backReScanImage(@ApiParam(value = "request", required = true) @Valid CheckBillImageRequest request
    );


    @ApiOperation(value = "校验岗单据批量提交", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/commit",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse commit(@ApiParam(value = "request", required = true) @Valid BaseBillCommitRequest request
    );


    @ApiOperation(value = "校验岗待提交统计单据数", notes = "校验岗待提交统计单据数", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/countInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getCountInfo(@ApiParam(value = "request", required = true) @Valid GetCountInfoRequest request
    );


    @ApiOperation(value = "校验岗挂起或重扫单证", notes = "校验岗挂起或重扫单证", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/hangAndReScanTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hangAndReScanTicket(@ApiParam(value = "request", required = true) @Valid CheckBillTicketRequest request
    );


    @ApiOperation(value = "校验岗单据挂起", notes = "校验岗单据挂起", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/hangBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hangBill(@ApiParam(value = "request", required = true) @Valid HangBillRequest request
    );


    @ApiOperation(value = "校验岗单据挂起单张影像", notes = "校验岗单据挂起单张影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/hangImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hangImage(@ApiParam(value = "request", required = true) @Valid CheckBillImageRequest request
    );


    @ApiOperation(value = "校验岗保存并提交单证", notes = "校验岗保存并提交单证", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/saveCommitTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveCommitTicket(@ApiParam(value = "request", required = true) @Valid CheckSaveCommitTicketRequest request
    );


    @ApiOperation(value = "校验岗生成清单", notes = "校验岗生成清单", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/checkBill/saveInvoiceCover",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveInvoiceCover(@ApiParam(value = "request", required = true) @Valid BaseBillCommitRequest request
    );

}
