package com.xforceplus.elephant.image.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.CollectErrorsRequest;
import com.xforceplus.elephant.image.client.model.MobileUploadHandleRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "common", description = "the common API", tags = "common")
public interface CommonApi {

    @ApiOperation(value = "子类列表", notes = "子类列表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/entity/{configDataMappingType}/children",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getEntityChildren(@ApiParam(value = "对象CODE", required = true) @PathVariable("configDataMappingType") Integer configDataMappingType
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "查看对象字段", notes = "查看对象字段", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/entity/{entityCode}/fields",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getEntityFields(@ApiParam(value = "对象CODE", required = true) @PathVariable("entityCode") String entityCode
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "查看对象字段", notes = "查看对象字段", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/userInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getUserInfo(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

    @ApiOperation(value = "获取当前租户配置", notes = "获取当前租户配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/common/settings",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse settings(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取用户部门配置", notes = "获取配置在数据字典中的用户部门配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/common/userDepartment",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse userDepartment(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

    @ApiOperation(value = "移动端上传处理", notes = "移动端上传处理", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/common/mobileUploadHandle",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse mobileUploadHandle(@ApiParam(value = "request", required = true) @Valid MobileUploadHandleRequest request
    );

    @ApiOperation(value = "保存菜单", notes = "保存菜单", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/configSettings/{code}",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse saveConfig(@PathVariable("code") String code, @RequestBody JSONObject data);

    @ApiOperation(value = "获取配置左侧菜单", notes = "获取配置左侧菜单", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/configSettings/menu",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getConfigMenu();

    @ApiOperation(value = "获取配置", notes = "获取配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/common/configSettings/{code}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getConfig(@PathVariable("code") String code);

    @ApiOperation(value = "上传前端异常", notes = "上传前端异常", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/common/collect/errors",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse addErrors(CollectErrorsRequest request);

}
