package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SaveSpecialInvoiceRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "specialInvoice", description = "the specialInvoiceDetail API", tags = "specialInvoice")
public interface SpecialInvoiceApi {

    @ApiOperation(value = "获取特殊行业发票数据字典配置", notes = "获取特殊行业发票数据字典配置", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/specialInvoice/getConfig",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getConfig();

    @ApiOperation(value = "保存特殊发票", notes = "保存特殊发票", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/saveSpecialInvoice",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveSpecialInvoice(@ApiParam(value = "request", required = true) @Valid SaveSpecialInvoiceRequest request);

}
