package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则编码验重request Datetime:    2021/6/10   18:13 Author:   cmq
 */
@ApiModel(description = "规则编码验重request")
@JsonInclude(NON_NULL)
public class CheckRuleCodeRepeatRequest extends BaseRequest {

    @JsonProperty("ruleId")
    private Long ruleId = null;

    @JsonProperty("ruleCode")
    private String ruleCode = null;

    @JsonProperty("tenant")
    private Long tenantId = null;

    /**
     * 批次号规则主键
     *
     * @return ruleId
     **/
    @ApiModelProperty(value = "批次号规则主键")
    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * 规则编号
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "规则编号")
    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    /**
     * 租户
     *
     * @return tenant
     **/
    @ApiModelProperty(value = "租户")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

}
