package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取单据详情Request
 */
@ApiModel(description = "获取单据详情Request")

@JsonInclude(NON_NULL)
public class GetBillDataDetailRequest extends BaseRequest {

    @JsonProperty("billDataId")
    private Long billDataId = null;

    @JsonIgnore
    public GetBillDataDetailRequest billDataId(Long billDataId) {
        this.billDataId = billDataId;
        return this;
    }

    /**
     * 单据iD
     *
     * @return billDataId
     **/
    @ApiModelProperty(value = "单据iD")
    public Long getBillDataId() {
        return billDataId;
    }

    public void setBillDataId(Long billDataId) {
        this.billDataId = billDataId;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBillDataDetailRequest getBillDataDetailRequest = (GetBillDataDetailRequest) o;
        return Objects.equals(this.billDataId, getBillDataDetailRequest.billDataId) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billDataId, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBillDataDetailRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billDataId: ").append(toIndentedString(billDataId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
