package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class GetImageReturnLogListRequest extends BaseRequest {

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("operateType")
    private Integer operateType = null;

    @JsonIgnore
    public GetImageReturnLogListRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public GetImageReturnLogListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetImageReturnLogListRequest operateType(Integer operateType) {
        this.operateType = operateType;
        return this;
    }

    /**
     * 0默认 1-退回 2-作废
     *
     * @return operateType
     **/
    @ApiModelProperty(value = "0默认 1-退回 2-作废")
    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetImageReturnLogListRequest getImageReturnLogListRequest = (GetImageReturnLogListRequest) o;
        return Objects.equals(this.imageId, getImageReturnLogListRequest.imageId) &&
            Objects.equals(this.billCode, getImageReturnLogListRequest.billCode) &&
            Objects.equals(this.operateType, getImageReturnLogListRequest.operateType) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, billCode, operateType, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageReturnLogListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    operateType: ").append(toIndentedString(operateType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
