package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 处理消息Request
 */
@ApiModel(description = "处理消息Request")

@JsonInclude(NON_NULL)
public class HandleMessageRequest extends BaseRequest {

    @JsonProperty("indexId")
    private Integer indexId = null;

    @JsonProperty("queueName")
    private String queueName = null;

    @JsonProperty("exchange")
    private String exchange = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("properties")
    private String properties = null;

    @JsonIgnore
    public HandleMessageRequest indexId(Integer indexId) {
        this.indexId = indexId;
        return this;
    }

    /**
     * 消息下标
     *
     * @return indexId
     **/
    @ApiModelProperty(value = "消息下标")
    public Integer getIndexId() {
        return indexId;
    }

    public void setIndexId(Integer indexId) {
        this.indexId = indexId;
    }

    @JsonIgnore
    public HandleMessageRequest queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    /**
     * 队列
     *
     * @return queueName
     **/
    @ApiModelProperty(value = "队列")
    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @JsonIgnore
    public HandleMessageRequest exchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    /**
     * 交换机
     *
     * @return exchange
     **/
    @ApiModelProperty(value = "交换机")
    public String getExchange() {
        return exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    @JsonIgnore
    public HandleMessageRequest message(String message) {
        this.message = message;
        return this;
    }

    /**
     * 消息体
     *
     * @return message
     **/
    @ApiModelProperty(value = "消息体")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public HandleMessageRequest properties(String properties) {
        this.properties = properties;
        return this;
    }

    /**
     * 消息属性
     *
     * @return properties
     **/
    @ApiModelProperty(value = "消息属性")
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HandleMessageRequest handleMessageRequest = (HandleMessageRequest) o;
        return Objects.equals(this.indexId, handleMessageRequest.indexId) &&
            Objects.equals(this.queueName, handleMessageRequest.queueName) &&
            Objects.equals(this.exchange, handleMessageRequest.exchange) &&
            Objects.equals(this.message, handleMessageRequest.message) &&
            Objects.equals(this.properties, handleMessageRequest.properties) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(indexId, queueName, exchange, message, properties, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HandleMessageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    indexId: ").append(toIndentedString(indexId)).append("\n");
        sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
        sb.append("    exchange: ").append(toIndentedString(exchange)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
