package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.annotation.Description;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 影像表
 */
@ApiModel(description = "影像表")

@JsonInclude(NON_NULL)
@Data
public class ImageDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("imageCategory")
    private String imageCategory = null;

    @JsonProperty("imageType")
    private String imageType = null;

    @JsonProperty("imageSource")
    private String imageSource = null;

    @JsonProperty("requireOcrFlag")
    private String requireOcrFlag = null;

    @JsonProperty("fileUrl")
    private String fileUrl = null;

    @JsonProperty("fileUrlHandle")
    private String fileUrlHandle = null;

    @JsonProperty("fileUrlOrigin")
    private String fileUrlOrigin = null;

    @JsonProperty("fileType")
    private String fileType = null;

    @JsonProperty("fileTypeHandle")
    private String fileTypeHandle = null;

    @JsonProperty("billSeq")
    private Long billSeq = null;

    @JsonProperty("fileOrder")
    private String fileOrder = null;

    @JsonProperty("fileLevel")
    private String fileLevel = null;

    @JsonProperty("recStatus")
    private String recStatus = null;

    @JsonProperty("taskId")
    private String taskId = null;

    @JsonProperty("copyCount")
    private String copyCount = null;

    @JsonProperty("recStartTime")
    private Long recStartTime = null;

    @JsonProperty("recEndTime")
    private Long recEndTime = null;

    @JsonProperty("billImageId")
    private Long billImageId = null;

    @JsonProperty("ticketImageId")
    private Long ticketImageId = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("isManualUnhook")
    private String isManualUnhook = null;

    @JsonProperty("isPublic")
    private String isPublic = null;

    @JsonProperty("exceptionStatus")
    private String exceptionStatus = null;

    @JsonProperty("returnStatus")
    private String returnStatus = null;

    @JsonProperty("returnReason")
    private String returnReason = null;

    @JsonProperty("returnRemark")
    private String returnRemark = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("reserved1")
    private String reserved1 = null;

    @JsonProperty("reserved2")
    private String reserved2 = null;

    @JsonProperty("reserved3")
    private String reserved3 = null;

    @JsonProperty("isReuse")
    private String isReuse = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("billEntityCode")
    private String billEntityCode = null;

    @JsonProperty("createUserCode")
    private String createUserCode = null;

    @JsonProperty("moreFileUrl")
    private String moreFileUrl = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("relExceptionInfo")
    private String relExceptionInfo = null;

    @JsonProperty("relWarningInfo")
    private String relWarningInfo = null;

    @JsonProperty("isCommit")
    private String isCommit = null;

    @JsonProperty("commitUserId")
    private Long commitUserId = null;

    @JsonProperty("commitUserName")
    private String commitUserName = null;

    @JsonProperty("commitTime")
    private Long commitTime = null;

    @JsonProperty("isHang")
    private String isHang = null;

    @JsonProperty("returnType")
    private String returnType = null;

    @JsonProperty("fileName")
    private String fileName = null;

    @JsonProperty("orgId")
    private Long orgId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("calculateStatus")
    private String calculateStatus = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("ticketName")
    private String ticketName = null;

    @JsonProperty("isAdd")
    private String isAdd = null;

    @JsonProperty("isChange")
    private String isChange = null;

    @JsonProperty("isReplace")
    private String isReplace = null;

    @JsonProperty("fileId")
    private Long fileId = null;

    @Description("稽核扫描匹配字段")
    private String compareScanMatchField;

    @Description("终审退回状态")
    private String auditBackStatus;

    @Description("含税金额")
    private String taxAmount;

    @Description("不含税金额")
    private String amountWithTax;

    @Description("流水号")
    private String serialNumber;

    @Description("已删除")
    private Boolean isDelete;

    @Description("已删除")
    private Boolean isReplaceOrder;

    @Description("warningDetail")
    private String warningDetail = null;
    @Description("warningKey")
    private String warningKey = null;
    @Description("exceptionDetail")
    private String exceptionDetail = null;
    @Description("exceptionKey")
    private String exceptionKey = null;

    private String systemOrig;

}
