package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * 单据退回接口
 */
@Data
@ApiModel(description = "单据退回接口")
@JsonInclude(NON_NULL)
public class NoticeBaseBillRequest extends BaseRequest {

    /**
     * 选中的单据集合
     */
    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    /**
     * 邮件通知内容
     */
    @JsonProperty("content")
    private String content;

    /**
     * 通知类型
     */
    @JsonProperty("type")
    private String type;

}
