package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 保存流水号request Datetime:    2021/6/10   18:32 Author:   cmq
 */
@ApiModel(description = "保存流水号request")
@JsonInclude(NON_NULL)
public class SaveSerialNumberRequest extends BaseRequest {

    @JsonProperty("ruleCode")
    private String ruleCode = null;

    @JsonProperty("date")
    private String date = null;

    @JsonProperty("enumeration")
    private String enumeration = null;

    @JsonProperty("serialNumber")
    private String serialNumber = null;

    /**
     * 规则编号
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "规则编号")
    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    /**
     * 日期值
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "日期值")
    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    /**
     * 枚举值
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "枚举值")
    public String getEnumeration() {
        return enumeration;
    }

    public void setEnumeration(String enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * 流水号值
     *
     * @return ruleCode
     **/
    @ApiModelProperty(value = "流水号值")
    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

}
