package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 票证数据Request
 */
@ApiModel(description = "票证数据Request")

@JsonInclude(NON_NULL)
public class SaveTicketDataRequest extends BaseRequest {

    @JsonProperty("operateType")
    private Integer operateType = null;

    @JsonProperty("parTicketId")
    private Long parTicketId = null;

    @JsonProperty("subTicketId")
    private Long subTicketId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("labelIdList")
    private List<Long> labelIdList = new ArrayList<Long>();

    @JsonProperty("formData")
    private String formData = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("xPoint")
    private Integer xPoint = null;

    @JsonProperty("yPoint")
    private Integer yPoint = null;

    @JsonProperty("width")
    private Integer width = null;

    @JsonProperty("height")
    private Integer height = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("scene")
    private String scene = null;

    @JsonProperty("usedAmount")
    private BigDecimal usedAmount = null;

    @JsonProperty("specialInvoiceFlag")
    private String specialInvoiceFlag = null;

    @JsonIgnore
    public SaveTicketDataRequest operateType(Integer operateType) {
        this.operateType = operateType;
        return this;
    }

    /**
     * 操作类型：1-新增,0-修改
     *
     * @return operateType
     **/
    @ApiModelProperty(value = "操作类型：1-新增,0-修改")
    public Integer getOperateType() {
        return operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    @JsonIgnore
    public SaveTicketDataRequest parTicketId(Long parTicketId) {
        this.parTicketId = parTicketId;
        return this;
    }

    /**
     * 父单证ID
     *
     * @return parTicketId
     **/
    @ApiModelProperty(value = "父单证ID")
    public Long getParTicketId() {
        return parTicketId;
    }

    public void setParTicketId(Long parTicketId) {
        this.parTicketId = parTicketId;
    }

    @JsonIgnore
    public SaveTicketDataRequest subTicketId(Long subTicketId) {
        this.subTicketId = subTicketId;
        return this;
    }

    /**
     * 子单证ID
     *
     * @return subTicketId
     **/
    @ApiModelProperty(value = "子单证ID")
    public Long getSubTicketId() {
        return subTicketId;
    }

    public void setSubTicketId(Long subTicketId) {
        this.subTicketId = subTicketId;
    }

    @JsonIgnore
    public SaveTicketDataRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public SaveTicketDataRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public SaveTicketDataRequest labelIdList(List<Long> labelIdList) {
        this.labelIdList = labelIdList;
        return this;
    }

    public SaveTicketDataRequest addLabelIdListItem(Long labelIdListItem) {
        this.labelIdList.add(labelIdListItem);
        return this;
    }

    /**
     * 标签集合
     *
     * @return labelIdList
     **/
    @ApiModelProperty(value = "标签集合")
    public List<Long> getLabelIdList() {
        return labelIdList;
    }

    public void setLabelIdList(List<Long> labelIdList) {
        this.labelIdList = labelIdList;
    }

    @JsonIgnore
    public SaveTicketDataRequest formData(String formData) {
        this.formData = formData;
        return this;
    }

    /**
     * 表单数据
     *
     * @return formData
     **/
    @ApiModelProperty(value = "表单数据")
    public String getFormData() {
        return formData;
    }

    public void setFormData(String formData) {
        this.formData = formData;
    }

    @JsonIgnore
    public SaveTicketDataRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public SaveTicketDataRequest xPoint(Integer xPoint) {
        this.xPoint = xPoint;
        return this;
    }

    /**
     * x点坐标
     *
     * @return xPoint
     **/
    @ApiModelProperty(value = "x点坐标")
    public Integer getXPoint() {
        return xPoint;
    }

    public void setXPoint(Integer xPoint) {
        this.xPoint = xPoint;
    }

    @JsonIgnore
    public SaveTicketDataRequest yPoint(Integer yPoint) {
        this.yPoint = yPoint;
        return this;
    }

    /**
     * y点坐标
     *
     * @return yPoint
     **/
    @ApiModelProperty(value = "y点坐标")
    public Integer getYPoint() {
        return yPoint;
    }

    public void setYPoint(Integer yPoint) {
        this.yPoint = yPoint;
    }

    @JsonIgnore
    public SaveTicketDataRequest width(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * 宽度
     *
     * @return width
     **/
    @ApiModelProperty(value = "宽度")
    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonIgnore
    public SaveTicketDataRequest height(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * 高度
     *
     * @return height
     **/
    @ApiModelProperty(value = "高度")
    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    /**
     * 页面Code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面Code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }


    public BigDecimal getUsedAmount() {
        return usedAmount;
    }

    public void setUsedAmount(BigDecimal usedAmount) {
        this.usedAmount = usedAmount;
    }

    public String getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SaveTicketDataRequest saveTicketDataRequest = (SaveTicketDataRequest) o;
        return Objects.equals(this.operateType, saveTicketDataRequest.operateType) &&
            Objects.equals(this.parTicketId, saveTicketDataRequest.parTicketId) &&
            Objects.equals(this.subTicketId, saveTicketDataRequest.subTicketId) &&
            Objects.equals(this.imageId, saveTicketDataRequest.imageId) &&
            Objects.equals(this.ticketCode, saveTicketDataRequest.ticketCode) &&
            Objects.equals(this.labelIdList, saveTicketDataRequest.labelIdList) &&
            Objects.equals(this.formData, saveTicketDataRequest.formData) &&
            Objects.equals(this.billCode, saveTicketDataRequest.billCode) &&
            Objects.equals(this.xPoint, saveTicketDataRequest.xPoint) &&
            Objects.equals(this.yPoint, saveTicketDataRequest.yPoint) &&
            Objects.equals(this.width, saveTicketDataRequest.width) &&
            Objects.equals(this.height, saveTicketDataRequest.height) &&
            Objects.equals(this.usedAmount, saveTicketDataRequest.usedAmount) &&
            Objects.equals(this.specialInvoiceFlag, saveTicketDataRequest.specialInvoiceFlag) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operateType, parTicketId, subTicketId, imageId, ticketCode, labelIdList, formData, billCode, xPoint, yPoint, width, height, usedAmount, specialInvoiceFlag, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveTicketDataRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    operateType: ").append(toIndentedString(operateType)).append("\n");
        sb.append("    parTicketId: ").append(toIndentedString(parTicketId)).append("\n");
        sb.append("    subTicketId: ").append(toIndentedString(subTicketId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    labelIdList: ").append(toIndentedString(labelIdList)).append("\n");
        sb.append("    formData: ").append(toIndentedString(formData)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    xPoint: ").append(toIndentedString(xPoint)).append("\n");
        sb.append("    yPoint: ").append(toIndentedString(yPoint)).append("\n");
        sb.append("    width: ").append(toIndentedString(width)).append("\n");
        sb.append("    height: ").append(toIndentedString(height)).append("\n");
        sb.append("    usedAmount: ").append(toIndentedString(usedAmount)).append("\n");
        sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
