package com.xforceplus.elephant.image.client.model;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import java.util.List;
import lombok.Data;

@Data
public class TicketRelationHandleRequest extends BaseRequest {

    /**
     * 条件组一：指定数据：提单/收单的影像id
     * imageId列表
     */
    private List<Long> imageIds;
    /**
     * 是否是稽核数据，默认false
     */
    private boolean compare;

    /**
     * 条件组二：指定租户的关系类型
     * 指定租户
     */
    private Long tenantId;
    /**
     * 重算的类型，默认全部
     */
    private List<String> types;

    /**
     * 公用条件
     * 使用新关系处理
     */
    private boolean newRelationHandle = true;

    /**
     * 分页大小
     */
    private int pageSize = 20;

}
