package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetLogisticsItemListRequest;
import com.xforceplus.elephant.image.client.model.SaveLogisticsItemRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsItemRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "logisticsItem", description = "the logisticsItem API", tags = "logisticsItem")
public interface LogisticsItemApi {

    @ApiOperation(value = "删除物流明细信息", notes = "删除物流明细信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/logisticsItem/{logisticsItemId}",
        produces = {"application/json"},
        method = RequestMethod.DELETE)
    CommonResponse deleteLogisticsItem(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsItemId") Long logisticsItemId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流明细详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/logisticsItem/{logisticsItemId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsItemDetail(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsItemId") Long logisticsItemId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流明细列表", notes = "获取物流明细数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logisticsItem",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsItemList(@ApiParam(value = "request", required = true) @Valid GetLogisticsItemListRequest request
    );


    @ApiOperation(value = "新增物流明细", notes = "新增物流明细", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/logisticsItem",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveLogisticsItem(@ApiParam(value = "request", required = true) @Valid SaveLogisticsItemRequest request
    );


    @ApiOperation(value = "更新物流明细信息", notes = "更新物流明细信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "更新结果")})
    @RequestMapping(value = "/logisticsItem",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse updateLogisticsItem(@ApiParam(value = "request", required = true) @Valid UpdateLogisticsItemRequest request
    );

}
