package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import java.util.List;

/**
 * @author yuhongxia
 * @description 补扫单据的单证影像
 * @date 2021/5/8 14:14
 */
@JsonInclude(NON_NULL)
public class InsertBillImageRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("parentImageId")
    private Long parentImageId = null;

    @JsonProperty("imageSource")
    private String imageSource = null;

    @JsonProperty("isPublic")
    private String isPublic = null;

    @JsonProperty("insertImageDTOList")
    private List<InsertImageDTO> insertImageDTOList = null;

    @JsonProperty("ext")
    private JSONObject ext = null;

    @JsonProperty("insertAttachmentImageDTOList")
    private List<InsertImageDTO> insertAttachmentImageDTOList = null;

    public String getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getParentImageId() {
        return parentImageId;
    }

    public void setParentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
    }


    public String getImageSource() {
        return imageSource;
    }

    public void setImageSource(String imageSource) {
        this.imageSource = imageSource;
    }

    public List<InsertImageDTO> getInsertImageDTOList() {
        return insertImageDTOList;
    }

    public void setInsertImageDTOList(List<InsertImageDTO> insertImageDTOList) {
        this.insertImageDTOList = insertImageDTOList;
    }

    public JSONObject getExt() {
        return ext;
    }

    public void setExt(JSONObject ext) {
        this.ext = ext;
    }

    public List<InsertImageDTO> getInsertAttachmentImageDTOList() {
        return insertAttachmentImageDTOList;
    }

    public void setInsertAttachmentImageDTOList(List<InsertImageDTO> insertAttachmentImageDTOList) {
        this.insertAttachmentImageDTOList = insertAttachmentImageDTOList;
    }
}
