package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 物流Request
 */
@ApiModel(description = "物流Request")

@JsonInclude(NON_NULL)
public class GetLogisticsListRequest extends PageRequest {

    @JsonProperty("logisticsId")
    private Long logisticsId = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("packageCode")
    private String packageCode = null;

    @JsonProperty("logisticsStatus")
    private Integer logisticsStatus = null;

    @JsonProperty("logisticsTime")
    private Long logisticsTime = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("senderTel")
    private String senderTel = null;

    @JsonProperty("senderAddr")
    private String senderAddr = null;

    @JsonProperty("senderCompany")
    private String senderCompany = null;

    @JsonProperty("senderTime")
    private Long senderTime = null;

    @JsonProperty("receiver")
    private String receiver = null;

    @JsonProperty("receiverTel")
    private String receiverTel = null;

    @JsonProperty("receiverAddr")
    private String receiverAddr = null;

    @JsonProperty("receiverCompany")
    private String receiverCompany = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonIgnore
    public GetLogisticsListRequest logisticsId(Long logisticsId) {
        this.logisticsId = logisticsId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return logisticsId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getLogisticsId() {
        return logisticsId;
    }

    public void setLogisticsId(Long logisticsId) {
        this.logisticsId = logisticsId;
    }

    @JsonIgnore
    public GetLogisticsListRequest tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public GetLogisticsListRequest packageCode(String packageCode) {
        this.packageCode = packageCode;
        return this;
    }

    /**
     * 运单号
     *
     * @return packageCode
     **/
    @ApiModelProperty(value = "运单号")
    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    @JsonIgnore
    public GetLogisticsListRequest logisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
        return this;
    }

    /**
     * 物流状态：0-待寄送，1-寄送中，2-已签收，3-异常
     *
     * @return logisticsStatus
     **/
    @ApiModelProperty(value = "物流状态：0-待寄送，1-寄送中，2-已签收，3-异常")
    public Integer getLogisticsStatus() {
        return logisticsStatus;
    }

    public void setLogisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    @JsonIgnore
    public GetLogisticsListRequest logisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
        return this;
    }

    /**
     * 状态变更时间
     *
     * @return logisticsTime
     **/
    @ApiModelProperty(value = "状态变更时间")
    public Long getLogisticsTime() {
        return logisticsTime;
    }

    public void setLogisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
    }

    @JsonIgnore
    public GetLogisticsListRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * 寄件人
     *
     * @return sender
     **/
    @ApiModelProperty(value = "寄件人")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public GetLogisticsListRequest senderTel(String senderTel) {
        this.senderTel = senderTel;
        return this;
    }

    /**
     * 寄件人电话
     *
     * @return senderTel
     **/
    @ApiModelProperty(value = "寄件人电话")
    public String getSenderTel() {
        return senderTel;
    }

    public void setSenderTel(String senderTel) {
        this.senderTel = senderTel;
    }

    @JsonIgnore
    public GetLogisticsListRequest senderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
        return this;
    }

    /**
     * 寄件人地址
     *
     * @return senderAddr
     **/
    @ApiModelProperty(value = "寄件人地址")
    public String getSenderAddr() {
        return senderAddr;
    }

    public void setSenderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
    }

    @JsonIgnore
    public GetLogisticsListRequest senderCompany(String senderCompany) {
        this.senderCompany = senderCompany;
        return this;
    }

    /**
     * 寄件人公司
     *
     * @return senderCompany
     **/
    @ApiModelProperty(value = "寄件人公司")
    public String getSenderCompany() {
        return senderCompany;
    }

    public void setSenderCompany(String senderCompany) {
        this.senderCompany = senderCompany;
    }

    @JsonIgnore
    public GetLogisticsListRequest senderTime(Long senderTime) {
        this.senderTime = senderTime;
        return this;
    }

    /**
     * 寄件时间
     *
     * @return senderTime
     **/
    @ApiModelProperty(value = "寄件时间")
    public Long getSenderTime() {
        return senderTime;
    }

    public void setSenderTime(Long senderTime) {
        this.senderTime = senderTime;
    }

    @JsonIgnore
    public GetLogisticsListRequest receiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    /**
     * 收件人
     *
     * @return receiver
     **/
    @ApiModelProperty(value = "收件人")
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @JsonIgnore
    public GetLogisticsListRequest receiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
        return this;
    }

    /**
     * 收件人电话
     *
     * @return receiverTel
     **/
    @ApiModelProperty(value = "收件人电话")
    public String getReceiverTel() {
        return receiverTel;
    }

    public void setReceiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
    }

    @JsonIgnore
    public GetLogisticsListRequest receiverAddr(String receiverAddr) {
        this.receiverAddr = receiverAddr;
        return this;
    }

    /**
     * 收件人地址
     *
     * @return receiverAddr
     **/
    @ApiModelProperty(value = "收件人地址")
    public String getReceiverAddr() {
        return receiverAddr;
    }

    public void setReceiverAddr(String receiverAddr) {
        this.receiverAddr = receiverAddr;
    }

    @JsonIgnore
    public GetLogisticsListRequest receiverCompany(String receiverCompany) {
        this.receiverCompany = receiverCompany;
        return this;
    }

    /**
     * 收件人公司
     *
     * @return receiverCompany
     **/
    @ApiModelProperty(value = "收件人公司")
    public String getReceiverCompany() {
        return receiverCompany;
    }

    public void setReceiverCompany(String receiverCompany) {
        this.receiverCompany = receiverCompany;
    }

    @JsonIgnore
    public GetLogisticsListRequest createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetLogisticsListRequest createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public GetLogisticsListRequest createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public GetLogisticsListRequest updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public GetLogisticsListRequest updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public GetLogisticsListRequest updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetLogisticsListRequest getLogisticsListRequest = (GetLogisticsListRequest) o;
        return Objects.equals(this.logisticsId, getLogisticsListRequest.logisticsId) &&
            Objects.equals(this.tenantId, getLogisticsListRequest.tenantId) &&
            Objects.equals(this.packageCode, getLogisticsListRequest.packageCode) &&
            Objects.equals(this.logisticsStatus, getLogisticsListRequest.logisticsStatus) &&
            Objects.equals(this.logisticsTime, getLogisticsListRequest.logisticsTime) &&
            Objects.equals(this.sender, getLogisticsListRequest.sender) &&
            Objects.equals(this.senderTel, getLogisticsListRequest.senderTel) &&
            Objects.equals(this.senderAddr, getLogisticsListRequest.senderAddr) &&
            Objects.equals(this.senderCompany, getLogisticsListRequest.senderCompany) &&
            Objects.equals(this.senderTime, getLogisticsListRequest.senderTime) &&
            Objects.equals(this.receiver, getLogisticsListRequest.receiver) &&
            Objects.equals(this.receiverTel, getLogisticsListRequest.receiverTel) &&
            Objects.equals(this.receiverAddr, getLogisticsListRequest.receiverAddr) &&
            Objects.equals(this.receiverCompany, getLogisticsListRequest.receiverCompany) &&
            Objects.equals(this.createTime, getLogisticsListRequest.createTime) &&
            Objects.equals(this.createUserId, getLogisticsListRequest.createUserId) &&
            Objects.equals(this.createUserName, getLogisticsListRequest.createUserName) &&
            Objects.equals(this.updateTime, getLogisticsListRequest.updateTime) &&
            Objects.equals(this.updateUserId, getLogisticsListRequest.updateUserId) &&
            Objects.equals(this.updateUserName, getLogisticsListRequest.updateUserName) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(logisticsId, tenantId, packageCode, logisticsStatus, logisticsTime, sender, senderTel, senderAddr, senderCompany, senderTime, receiver, receiverTel, receiverAddr, receiverCompany,
                createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetLogisticsListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    logisticsId: ").append(toIndentedString(logisticsId)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
        sb.append("    logisticsStatus: ").append(toIndentedString(logisticsStatus)).append("\n");
        sb.append("    logisticsTime: ").append(toIndentedString(logisticsTime)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    senderTel: ").append(toIndentedString(senderTel)).append("\n");
        sb.append("    senderAddr: ").append(toIndentedString(senderAddr)).append("\n");
        sb.append("    senderCompany: ").append(toIndentedString(senderCompany)).append("\n");
        sb.append("    senderTime: ").append(toIndentedString(senderTime)).append("\n");
        sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
        sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
        sb.append("    receiverAddr: ").append(toIndentedString(receiverAddr)).append("\n");
        sb.append("    receiverCompany: ").append(toIndentedString(receiverCompany)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
