package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 单据挂起请求
 */
@ApiModel(description = "单据挂起请求")

@JsonInclude(NON_NULL)
public class HangBillRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonProperty("hangType")
    private Integer hangType = null;

    @JsonProperty("hangReason")
    private String hangReason = null;

    @JsonIgnore
    public HangBillRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public HangBillRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }

    @JsonIgnore
    public HangBillRequest hangType(Integer hangType) {
        this.hangType = hangType;
        return this;
    }

    /**
     * 挂起原因
     *
     * @return hangType
     **/
    @ApiModelProperty(value = "挂起原因")
    public Integer getHangType() {
        return hangType;
    }

    public void setHangType(Integer hangType) {
        this.hangType = hangType;
    }

    @JsonIgnore
    public HangBillRequest hangReason(String hangReason) {
        this.hangReason = hangReason;
        return this;
    }

    /**
     * 挂起原因备注
     *
     * @return hangReason
     **/
    @ApiModelProperty(value = "挂起原因备注")
    public String getHangReason() {
        return hangReason;
    }

    public void setHangReason(String hangReason) {
        this.hangReason = hangReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HangBillRequest hangBillRequest = (HangBillRequest) o;
        return Objects.equals(this.billCodes, hangBillRequest.billCodes) &&
            Objects.equals(this.hangType, hangBillRequest.hangType) &&
            Objects.equals(this.hangReason, hangBillRequest.hangReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, hangType, hangReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HangBillRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("    hangType: ").append(toIndentedString(hangType)).append("\n");
        sb.append("    hangReason: ").append(toIndentedString(hangReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
