package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 替换扫描人request
 */
@ApiModel(description = "替换扫描人request")

@JsonInclude(NON_NULL)
public class ReplaceScanUserRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonProperty("scanUserId")
    private Long scanUserId = null;

    @JsonProperty("scanUserName")
    private String scanUserName = null;

    @JsonIgnore
    public ReplaceScanUserRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public ReplaceScanUserRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }

    @JsonIgnore
    public ReplaceScanUserRequest scanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
        return this;
    }

    /**
     * 扫描人id
     *
     * @return scanUserId
     **/
    @ApiModelProperty(value = "扫描人id")
    public Long getScanUserId() {
        return scanUserId;
    }

    public void setScanUserId(Long scanUserId) {
        this.scanUserId = scanUserId;
    }

    @JsonIgnore
    public ReplaceScanUserRequest scanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
        return this;
    }

    /**
     * 扫描人姓名
     *
     * @return scanUserName
     **/
    @ApiModelProperty(value = "扫描人姓名")
    public String getScanUserName() {
        return scanUserName;
    }

    public void setScanUserName(String scanUserName) {
        this.scanUserName = scanUserName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReplaceScanUserRequest replaceScanUserRequest = (ReplaceScanUserRequest) o;
        return Objects.equals(this.billCodes, replaceScanUserRequest.billCodes) &&
            Objects.equals(this.scanUserId, replaceScanUserRequest.scanUserId) &&
            Objects.equals(this.scanUserName, replaceScanUserRequest.scanUserName) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, scanUserId, scanUserName, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceScanUserRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("    scanUserId: ").append(toIndentedString(scanUserId)).append("\n");
        sb.append("    scanUserName: ").append(toIndentedString(scanUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
