package com.xforceplus.elephant.image.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Data;

/**
 * @program: phoenix-purconfig-app
 * @description:
 * @author: cuixiangyu
 * @created: 2020-06-05 13:35
 */
@Data
public class UploadPictureResponse {

    @JsonProperty("code")
    private Integer code;
    @JsonProperty("message")
    private String message;
    @JsonProperty("result")
    private List<PictureBean> result;

    @JsonIgnore
    public UploadPictureResponse init(Integer code, String message, List<PictureBean> result) {
        this.code = code;
        this.message = message;
        this.result = result;
        return this;
    }

    @Data
    public static class PictureBean {

        @JsonProperty("fileName")
        private String fileName;
        @JsonProperty("fileUrl")
        private String fileUrl;

    }

}
