package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 旋转影像Request
 */
@ApiModel(description = "旋转影像Request")

@JsonInclude(NON_NULL)
public class RotateImageRequest extends BaseRequest {

    @JsonProperty("rotate")
    private Integer rotate = null;

    @JsonIgnore
    public RotateImageRequest rotate(Integer rotate) {
        this.rotate = rotate;
        return this;
    }

    /**
     * 角度
     *
     * @return rotate
     **/
    @ApiModelProperty(value = "角度")
    public Integer getRotate() {
        return rotate;
    }

    public void setRotate(Integer rotate) {
        this.rotate = rotate;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RotateImageRequest rotateImageRequest = (RotateImageRequest) o;
        return Objects.equals(this.rotate, rotateImageRequest.rotate) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(rotate, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RotateImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    rotate: ").append(toIndentedString(rotate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
