package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 挂接认领单证Request
 */
@ApiModel(description = "挂接认领单证Request")

@JsonInclude(NON_NULL)
public class HookedClaimTicketRequest extends BaseRequest {

    @JsonProperty("imageIdList")
    private List<Long> imageIdList = new ArrayList<Long>();

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("isConfirm")
    private Integer isConfirm = null;

    @JsonIgnore
    public HookedClaimTicketRequest imageIdList(List<Long> imageIdList) {
        this.imageIdList = imageIdList;
        return this;
    }

    public HookedClaimTicketRequest addImageIdListItem(Long imageIdListItem) {
        this.imageIdList.add(imageIdListItem);
        return this;
    }

    /**
     * 影像IDList
     *
     * @return imageIdList
     **/
    @ApiModelProperty(value = "影像IDList")
    public List<Long> getImageIdList() {
        return imageIdList;
    }

    public void setImageIdList(List<Long> imageIdList) {
        this.imageIdList = imageIdList;
    }

    @JsonIgnore
    public HookedClaimTicketRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public HookedClaimTicketRequest isConfirm(Integer isConfirm) {
        this.isConfirm = isConfirm;
        return this;
    }

    /**
     * 二次确认：0-否，1-是
     *
     * @return isConfirm
     **/
    @ApiModelProperty(value = "二次确认：0-否，1-是")
    public Integer getIsConfirm() {
        return isConfirm;
    }

    public void setIsConfirm(Integer isConfirm) {
        this.isConfirm = isConfirm;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HookedClaimTicketRequest hookedClaimTicketRequest = (HookedClaimTicketRequest) o;
        return Objects.equals(this.imageIdList, hookedClaimTicketRequest.imageIdList) &&
            Objects.equals(this.billCode, hookedClaimTicketRequest.billCode) &&
            Objects.equals(this.isConfirm, hookedClaimTicketRequest.isConfirm) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageIdList, billCode, isConfirm, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HookedClaimTicketRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageIdList: ").append(toIndentedString(imageIdList)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    isConfirm: ").append(toIndentedString(isConfirm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
