package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class SaveImageOrCopyRequest extends BaseRequest {

    @JsonProperty("type")
    private Integer type = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("copyName")
    private String copyName = null;

    @JsonProperty("imageContent")
    private String imageContent = null;

    @JsonProperty("rotate")
    private Integer rotate = null;

    @JsonIgnore
    public SaveImageOrCopyRequest type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * 操作类型：1-覆盖原图 2-创建副本 3-创建封面
     *
     * @return type
     **/
    @ApiModelProperty(value = "操作类型：1-覆盖原图 2-创建副本 3-创建封面")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public SaveImageOrCopyRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public SaveImageOrCopyRequest copyName(String copyName) {
        this.copyName = copyName;
        return this;
    }

    /**
     * 副本名称
     *
     * @return copyName
     **/
    @ApiModelProperty(value = "副本名称")
    public String getCopyName() {
        return copyName;
    }

    public void setCopyName(String copyName) {
        this.copyName = copyName;
    }

    @JsonIgnore
    public SaveImageOrCopyRequest imageContent(String imageContent) {
        this.imageContent = imageContent;
        return this;
    }

    /**
     * base64字符串
     *
     * @return imageContent
     **/
    @ApiModelProperty(value = "base64字符串")
    public String getImageContent() {
        return imageContent;
    }

    public void setImageContent(String imageContent) {
        this.imageContent = imageContent;
    }

    @JsonIgnore
    public SaveImageOrCopyRequest rotate(Integer rotate) {
        this.rotate = rotate;
        return this;
    }

    /**
     * 旋转角度
     *
     * @return rotate
     **/
    @ApiModelProperty(value = "旋转角度")
    public Integer getRotate() {
        return rotate;
    }

    public void setRotate(Integer rotate) {
        this.rotate = rotate;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SaveImageOrCopyRequest saveImageOrCopyRequest = (SaveImageOrCopyRequest) o;
        return Objects.equals(this.type, saveImageOrCopyRequest.type) &&
            Objects.equals(this.billCode, saveImageOrCopyRequest.billCode) &&
            Objects.equals(this.copyName, saveImageOrCopyRequest.copyName) &&
            Objects.equals(this.imageContent, saveImageOrCopyRequest.imageContent) &&
            Objects.equals(this.rotate, saveImageOrCopyRequest.rotate) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, billCode, copyName, imageContent, rotate, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveImageOrCopyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    copyName: ").append(toIndentedString(copyName)).append("\n");
        sb.append("    imageContent: ").append(toIndentedString(imageContent)).append("\n");
        sb.append("    rotate: ").append(toIndentedString(rotate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
