package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 校验岗单据单证请求
 */
@ApiModel(description = "校验岗单据单证请求")

@JsonInclude(NON_NULL)
public class CheckBillTicketRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("handleType")
    private Integer handleType = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonIgnore
    public CheckBillTicketRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public CheckBillTicketRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public CheckBillTicketRequest handleType(Integer handleType) {
        this.handleType = handleType;
        return this;
    }

    /**
     * 处理类型：0-挂起，1-退回重扫
     *
     * @return handleType
     **/
    @ApiModelProperty(value = "处理类型：0-挂起，1-退回重扫")
    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    @JsonIgnore
    public CheckBillTicketRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckBillTicketRequest checkBillTicketRequest = (CheckBillTicketRequest) o;
        return Objects.equals(this.billCode, checkBillTicketRequest.billCode) &&
            Objects.equals(this.imageId, checkBillTicketRequest.imageId) &&
            Objects.equals(this.handleType, checkBillTicketRequest.handleType) &&
            Objects.equals(this.backReason, checkBillTicketRequest.backReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, imageId, handleType, backReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckBillTicketRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    handleType: ").append(toIndentedString(handleType)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
