package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 物流
 */
@ApiModel(description = "物流")

@JsonInclude(NON_NULL)
public class LogisticsPostcodeDTO {

    @JsonProperty("logisticsPostcodeId")
    private Long logisticsPostcodeId = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("packageCode")
    private String packageCode = null;

    @JsonProperty("logisticsStatus")
    private Integer logisticsStatus = null;

    @JsonProperty("logisticsTime")
    private Long logisticsTime = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("senderTel")
    private String senderTel = null;

    @JsonProperty("senderAddr")
    private String senderAddr = null;

    @JsonProperty("senderCompany")
    private String senderCompany = null;

    @JsonProperty("senderTime")
    private Long senderTime = null;

    @JsonProperty("receiver")
    private String receiver = null;

    @JsonProperty("receiverTel")
    private String receiverTel = null;

    @JsonProperty("receiverAddr")
    private String receiverAddr = null;

    @JsonProperty("receiverCompany")
    private String receiverCompany = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonIgnore
    public LogisticsPostcodeDTO logisticsPostcodeId(Long logisticsPostcodeId) {
        this.logisticsPostcodeId = logisticsPostcodeId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return logisticsPostcodeId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getLogisticsPostcodeId() {
        return logisticsPostcodeId;
    }

    public void setLogisticsPostcodeId(Long logisticsPostcodeId) {
        this.logisticsPostcodeId = logisticsPostcodeId;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO packageCode(String packageCode) {
        this.packageCode = packageCode;
        return this;
    }

    /**
     * 运单号
     *
     * @return packageCode
     **/
    @ApiModelProperty(value = "运单号")
    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO logisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
        return this;
    }

    /**
     * 物流状态：0-待寄送，1-寄送中，2-已签收，3-异常
     *
     * @return logisticsStatus
     **/
    @ApiModelProperty(value = "物流状态：0-待寄送，1-寄送中，2-已签收，3-异常")
    public Integer getLogisticsStatus() {
        return logisticsStatus;
    }

    public void setLogisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO logisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
        return this;
    }

    /**
     * 状态变更时间
     *
     * @return logisticsTime
     **/
    @ApiModelProperty(value = "状态变更时间")
    public Long getLogisticsTime() {
        return logisticsTime;
    }

    public void setLogisticsTime(Long logisticsTime) {
        this.logisticsTime = logisticsTime;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * 寄件人
     *
     * @return sender
     **/
    @ApiModelProperty(value = "寄件人")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO senderTel(String senderTel) {
        this.senderTel = senderTel;
        return this;
    }

    /**
     * 寄件人电话
     *
     * @return senderTel
     **/
    @ApiModelProperty(value = "寄件人电话")
    public String getSenderTel() {
        return senderTel;
    }

    public void setSenderTel(String senderTel) {
        this.senderTel = senderTel;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO senderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
        return this;
    }

    /**
     * 寄件人地址
     *
     * @return senderAddr
     **/
    @ApiModelProperty(value = "寄件人地址")
    public String getSenderAddr() {
        return senderAddr;
    }

    public void setSenderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO senderCompany(String senderCompany) {
        this.senderCompany = senderCompany;
        return this;
    }

    /**
     * 寄件人公司
     *
     * @return senderCompany
     **/
    @ApiModelProperty(value = "寄件人公司")
    public String getSenderCompany() {
        return senderCompany;
    }

    public void setSenderCompany(String senderCompany) {
        this.senderCompany = senderCompany;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO senderTime(Long senderTime) {
        this.senderTime = senderTime;
        return this;
    }

    /**
     * 寄件时间
     *
     * @return senderTime
     **/
    @ApiModelProperty(value = "寄件时间")
    public Long getSenderTime() {
        return senderTime;
    }

    public void setSenderTime(Long senderTime) {
        this.senderTime = senderTime;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO receiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    /**
     * 收件人
     *
     * @return receiver
     **/
    @ApiModelProperty(value = "收件人")
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO receiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
        return this;
    }

    /**
     * 收件人电话
     *
     * @return receiverTel
     **/
    @ApiModelProperty(value = "收件人电话")
    public String getReceiverTel() {
        return receiverTel;
    }

    public void setReceiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO receiverAddr(String receiverAddr) {
        this.receiverAddr = receiverAddr;
        return this;
    }

    /**
     * 收件人地址
     *
     * @return receiverAddr
     **/
    @ApiModelProperty(value = "收件人地址")
    public String getReceiverAddr() {
        return receiverAddr;
    }

    public void setReceiverAddr(String receiverAddr) {
        this.receiverAddr = receiverAddr;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO receiverCompany(String receiverCompany) {
        this.receiverCompany = receiverCompany;
        return this;
    }

    /**
     * 收件人公司
     *
     * @return receiverCompany
     **/
    @ApiModelProperty(value = "收件人公司")
    public String getReceiverCompany() {
        return receiverCompany;
    }

    public void setReceiverCompany(String receiverCompany) {
        this.receiverCompany = receiverCompany;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public LogisticsPostcodeDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogisticsPostcodeDTO logisticsPostcodeDTO = (LogisticsPostcodeDTO) o;
        return Objects.equals(this.logisticsPostcodeId, logisticsPostcodeDTO.logisticsPostcodeId) &&
            Objects.equals(this.tenantId, logisticsPostcodeDTO.tenantId) &&
            Objects.equals(this.packageCode, logisticsPostcodeDTO.packageCode) &&
            Objects.equals(this.logisticsStatus, logisticsPostcodeDTO.logisticsStatus) &&
            Objects.equals(this.logisticsTime, logisticsPostcodeDTO.logisticsTime) &&
            Objects.equals(this.sender, logisticsPostcodeDTO.sender) &&
            Objects.equals(this.senderTel, logisticsPostcodeDTO.senderTel) &&
            Objects.equals(this.senderAddr, logisticsPostcodeDTO.senderAddr) &&
            Objects.equals(this.senderCompany, logisticsPostcodeDTO.senderCompany) &&
            Objects.equals(this.senderTime, logisticsPostcodeDTO.senderTime) &&
            Objects.equals(this.receiver, logisticsPostcodeDTO.receiver) &&
            Objects.equals(this.receiverTel, logisticsPostcodeDTO.receiverTel) &&
            Objects.equals(this.receiverAddr, logisticsPostcodeDTO.receiverAddr) &&
            Objects.equals(this.receiverCompany, logisticsPostcodeDTO.receiverCompany) &&
            Objects.equals(this.createTime, logisticsPostcodeDTO.createTime) &&
            Objects.equals(this.createUserId, logisticsPostcodeDTO.createUserId) &&
            Objects.equals(this.createUserName, logisticsPostcodeDTO.createUserName) &&
            Objects.equals(this.updateTime, logisticsPostcodeDTO.updateTime) &&
            Objects.equals(this.updateUserId, logisticsPostcodeDTO.updateUserId) &&
            Objects.equals(this.updateUserName, logisticsPostcodeDTO.updateUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(logisticsPostcodeId, tenantId, packageCode, logisticsStatus, logisticsTime, sender, senderTel, senderAddr, senderCompany, senderTime, receiver, receiverTel, receiverAddr,
            receiverCompany, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogisticsPostcodeDTO {\n");

        sb.append("    logisticsPostcodeId: ").append(toIndentedString(logisticsPostcodeId)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
        sb.append("    logisticsStatus: ").append(toIndentedString(logisticsStatus)).append("\n");
        sb.append("    logisticsTime: ").append(toIndentedString(logisticsTime)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    senderTel: ").append(toIndentedString(senderTel)).append("\n");
        sb.append("    senderAddr: ").append(toIndentedString(senderAddr)).append("\n");
        sb.append("    senderCompany: ").append(toIndentedString(senderCompany)).append("\n");
        sb.append("    senderTime: ").append(toIndentedString(senderTime)).append("\n");
        sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
        sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
        sb.append("    receiverAddr: ").append(toIndentedString(receiverAddr)).append("\n");
        sb.append("    receiverCompany: ").append(toIndentedString(receiverCompany)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
