package com.xforceplus.elephant.image.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 重新下发请求
 *
 * @author 批量下发
 * @date 2015/09/28 13:12
 */
@Data
public class RePushBillsResult implements Serializable {

    private Integer totalCount;
    private Integer successCount;
    private Integer failedCount;
    private List<RePushBillItem> success = new ArrayList<>();
    private List<RePushBillItem> failed = new ArrayList<>();

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class RePushBillItem {
        private String billCode;
        private String message;
    }

}
