package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * UnhookImageRequest
 */

@JsonInclude(NON_NULL)
public class UnhookImageRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("imageIds")
    private List<Long> imageIds = new ArrayList<Long>();

    @JsonIgnore
    public UnhookImageRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public UnhookImageRequest imageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
        return this;
    }

    public UnhookImageRequest addImageIdsItem(Long imageIdsItem) {
        this.imageIds.add(imageIdsItem);
        return this;
    }

    /**
     * 影像ids
     *
     * @return imageIds
     **/
    @ApiModelProperty(value = "影像ids")
    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnhookImageRequest unhookImageRequest = (UnhookImageRequest) o;
        return Objects.equals(this.billCode, unhookImageRequest.billCode) &&
            Objects.equals(this.imageIds, unhookImageRequest.imageIds) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, imageIds, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnhookImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    imageIds: ").append(toIndentedString(imageIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
