package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 根据单据号批量下载影像request
 */
@ApiModel(description = "根据单据号批量下载影像request")

@JsonInclude(NON_NULL)
public class BatchDownloadImageRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonIgnore
    public BatchDownloadImageRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public BatchDownloadImageRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BatchDownloadImageRequest batchDownloadImageRequest = (BatchDownloadImageRequest) o;
        return Objects.equals(this.billCodes, batchDownloadImageRequest.billCodes) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchDownloadImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
