package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.EnableDataMappingRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "config", description = "the config API", tags = "config")
public interface ConfigApi {

    @ApiOperation(value = "更新识别规则状态", notes = "更新识别规则状态", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/config/enableDataMapping",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse enableDataMapping(@ApiParam(value = "request", required = true) @Valid EnableDataMappingRequest request
    );

}
