package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetImageCopyListRequest;
import com.xforceplus.elephant.image.client.model.SaveImageCopyRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "imageCopy", description = "the imageCopy API", tags = "imageCopy")
public interface ImageCopyApi {

    @ApiOperation(value = "删除影像表信息", notes = "删除影像表信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/imageCopy/{imageCopyId:[0-9]+}",
        produces = {"application/json"},
        method = RequestMethod.DELETE)
    CommonResponse deleteImageCopy(@ApiParam(value = "自增主键", required = true) @PathVariable("imageCopyId") Long imageCopyId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取影像表输出流", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/imageCopy/{imageCopyId:[0-9]+}.{fileExt}",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object getImageCopyFile(@ApiParam(value = "自增主键", required = true) @PathVariable("imageCopyId") Long imageCopyId
        , @ApiParam(value = "文件类型", required = true) @PathVariable("fileExt") String fileExt
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取影像表列表", notes = "获取影像表数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/imageCopy",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getImageCopyList(@ApiParam(value = "request", required = true) @Valid GetImageCopyListRequest request
    );


    @ApiOperation(value = "获取影像表输出流", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/imageCopy/{imageCopyId}/stream",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object getImageCopyStream(@ApiParam(value = "自增主键", required = true) @PathVariable("imageCopyId") Long imageCopyId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "新增影像表", notes = "新增影像表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/imageCopy",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveImageCopy(@ApiParam(value = "request", required = true) @Valid SaveImageCopyRequest request
    );

}
