package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetPubSubLogListRequest;
import com.xforceplus.elephant.image.client.model.RetryPubSubRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "pubSubLog", description = "the pubSubLog API", tags = "pubSubLog")
public interface PubSubLogApi {

    @ApiOperation(value = "获取详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/pubSubLog/{logId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogApiDetail(@ApiParam(value = "", required = true) @PathVariable("logId") Long logId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取列表", notes = "获取数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/pubSubLog/getPubSubLogList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getPubSubLogList(@ApiParam(value = "request", required = true) @Valid GetPubSubLogListRequest request
    );


    @ApiOperation(value = "重试接口", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/pubSubLog/retry",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse pubSubRetry(@ApiParam(value = "request", required = true) @Valid RetryPubSubRequest request
    );

}
