package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.UploadFile;
import com.xforceplus.elephant.image.client.model.UploadPictureResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2025/3/10 16:49
 */
@Api(value = "upload image", description = "the upload image API", tags = "image")
public interface UploadImageApi {

    @ApiOperation(value = "上传图片", notes = "", response = UploadPictureResponse.class, tags = {"common",})
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "上传图片响应结果", response = UploadPictureResponse.class)})
    @RequestMapping(value = "/tools/picture-upload", method = RequestMethod.POST)
    CommonResponse<List<UploadFile>> uploadPicture(@ApiParam(value = "上传图片", required = true) @RequestPart("file") MultipartFile... file);

}
