package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class SaveImageCopyRequest extends BaseRequest {

    @JsonProperty("parentImageId")
    private Long parentImageId = null;

    @JsonProperty("copyName")
    private String copyName = null;

    @JsonProperty("imageContent")
    private String imageContent = null;

    @JsonIgnore
    public SaveImageCopyRequest parentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
        return this;
    }

    /**
     * 主影像ID
     *
     * @return parentImageId
     **/
    @ApiModelProperty(value = "主影像ID")
    public Long getParentImageId() {
        return parentImageId;
    }

    public void setParentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
    }

    @JsonIgnore
    public SaveImageCopyRequest copyName(String copyName) {
        this.copyName = copyName;
        return this;
    }

    /**
     * 副本名称
     *
     * @return copyName
     **/
    @ApiModelProperty(value = "副本名称")
    public String getCopyName() {
        return copyName;
    }

    public void setCopyName(String copyName) {
        this.copyName = copyName;
    }

    @JsonIgnore
    public SaveImageCopyRequest imageContent(String imageContent) {
        this.imageContent = imageContent;
        return this;
    }

    /**
     * base64字符串
     *
     * @return imageContent
     **/
    @ApiModelProperty(value = "base64字符串")
    public String getImageContent() {
        return imageContent;
    }

    public void setImageContent(String imageContent) {
        this.imageContent = imageContent;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SaveImageCopyRequest saveImageCopyRequest = (SaveImageCopyRequest) o;
        return Objects.equals(this.parentImageId, saveImageCopyRequest.parentImageId) &&
            Objects.equals(this.copyName, saveImageCopyRequest.copyName) &&
            Objects.equals(this.imageContent, saveImageCopyRequest.imageContent) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parentImageId, copyName, imageContent, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveImageCopyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    parentImageId: ").append(toIndentedString(parentImageId)).append("\n");
        sb.append("    copyName: ").append(toIndentedString(copyName)).append("\n");
        sb.append("    imageContent: ").append(toIndentedString(imageContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
