package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import lombok.Data;

/**
 * 发送验真Request
 */
@ApiModel(description = "发送验真Request")
@Data
@JsonInclude(NON_NULL)
public class SendVerifyRequest extends GetImageListRequest {

    @JsonProperty("ticketId")
    private Long ticketId = null;

    @JsonProperty("ticketIds")
    private List<Long> ticketIds;

    @JsonProperty("isCompare")
    private Boolean isCompare;

    /**
     * 是否全选
     */
    @JsonProperty("allSelected")
    private Boolean allSelected;

    /**
     * 勾选记录
     */
    @JsonProperty("included")
    private List<String> included = Lists.newArrayList();

    /**
     * 反选记录
     */
    @JsonProperty("excluded")
    private List<String> excluded = Lists.newArrayList();

    /**
     * 最终要操作的记录,不是外部传入
     */
    private List<Long> ids = Lists.newArrayList();

    /**
     * 验真字段来源:1-使用二维码解析字段，2-使用票面信息字段
     */
    private String verifyFieldOriginal;

    @JsonIgnore
    public SendVerifyRequest ticketId(Long ticketId) {
        this.ticketId = ticketId;
        return this;
    }

    /**
     * 单证主键
     *
     * @return ticketId
     **/
    @ApiModelProperty(value = "单证主键")
    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SendVerifyRequest sendVerifyRequest = (SendVerifyRequest) o;
        return Objects.equals(this.ticketId, sendVerifyRequest.ticketId) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketId, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendVerifyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketId: ").append(toIndentedString(ticketId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
