/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.CancelReturnImageRequest;
import com.xforceplus.elephant.image.client.model.CountRecStatusRequest;
import com.xforceplus.elephant.image.client.model.CutImageRequest;
import com.xforceplus.elephant.image.client.model.DownloadImageFileRequest;
import com.xforceplus.elephant.image.client.model.GetCoverImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageReturnListRequest;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.client.model.MoveImageRequest;
import com.xforceplus.elephant.image.client.model.ReturnImageRequest;
import com.xforceplus.elephant.image.client.model.RotateImageRequest;
import com.xforceplus.elephant.image.client.model.SaveImageOrCopyRequest;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.client.model.SourceFileUploadRequest;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.concurrent.ExecutionException;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="image", description="the image API", tags={"image"})
public interface ImageApi {
    @ApiOperation(value="\u6807\u8bb0\u5f71\u50cf\u53d6\u6d88\u9000\u56de", notes="\u6807\u8bb0\u5f71\u50cf\u53d6\u6d88\u9000\u56de", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ed3\u679c")})
    @RequestMapping(value={"/image/cancelReturn"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse cancelReturnImage(@ApiParam(value="request", required=true) @Valid CancelReturnImageRequest var1);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u5404\u7ef4\u5ea6\u8bc6\u522b\u72b6\u6001\u5206\u7ec4\u7edf\u8ba1\u6570", notes="\u83b7\u53d6\u5f71\u50cf\u5404\u7ef4\u5ea6\u8bc6\u522b\u72b6\u6001\u5206\u7ec4\u7edf\u8ba1\u6570", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6570\u636e\u5217\u8868")})
    @RequestMapping(value={"/image/countRecStatus"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse countRecStatus(@ApiParam(value="request", required=true) @Valid CountRecStatusRequest var1) throws ExecutionException;

    @ApiOperation(value="\u5220\u9664\u5f71\u50cf\u8868\u4fe1\u606f", notes="\u5220\u9664\u5f71\u50cf\u8868\u4fe1\u606f", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u5220\u9664\u7ed3\u679c")})
    @RequestMapping(value={"/image"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public CommonResponse deleteImage(@ApiParam(value="request", required=true) @Valid BillSelectAllRequest var1);

    @ApiOperation(value="\u5355\u636e\u8be6\u60c5\u4e0b\u8f7d\u5f71\u50cf\u6e90\u6587\u4ef6", notes="", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="response")})
    @RequestMapping(value={"/image/downloadImageFile"}, produces={"application/octet-stream"}, method={RequestMethod.GET})
    public Object downloadImageFile(@ApiParam(value="request", required=true) @Valid DownloadImageFileRequest var1);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u8868\u8be6\u60c5", notes="", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="response")})
    @RequestMapping(value={"/image/{imageId:[0-9]+}"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse getImageDetail(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid BaseRequest var2);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u8868\u8f93\u51fa\u6d41", notes="", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="response")})
    @RequestMapping(value={"/image/{imageId:[0-9]+}.{fileExt}"}, produces={"application/octet-stream"}, method={RequestMethod.GET})
    public Object getImageFile(@ApiParam(value="\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="\u6587\u4ef6\u7c7b\u578b", required=true) @PathVariable(value="fileExt") String var2, @ApiParam(value="request", required=true) @Valid GetImageStreamRequest var3);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u8868\u5217\u8868", notes="\u83b7\u53d6\u5f71\u50cf\u8868\u6570\u636e", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6570\u636e\u5217\u8868")})
    @RequestMapping(value={"/image"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse getImageList(@ApiParam(value="request", required=true) @Valid GetImageListRequest var1);

    @ApiOperation(value="\u5355\u636e\u5217\u8868\u9875(\u5c01\u9762\u548c\u53d1\u7968\u6df7\u626b\uff0c\u56fe\u7247\u548cPDF)", notes="\u4f7f\u7528\u626b\u63cf\u4eea\u6216\u4e0a\u4f20\uff0c\u5165\u53c2\u662furl", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6570\u636e\u5217\u8868")})
    @RequestMapping(value={"/image/list"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse getImageListPost(@ApiParam(value="request", required=true) @Valid GetImageListRequest var1);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u9000\u56de\u5217\u8868", notes="\u83b7\u53d6\u5f71\u50cf\u9000\u56de\u6570\u636e", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6570\u636e\u5217\u8868")})
    @RequestMapping(value={"/image/return"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse getImageReturnList(@ApiParam(value="request", required=true) @Valid GetImageReturnListRequest var1);

    @ApiOperation(value="\u83b7\u53d6\u5f71\u50cf\u8868\u8f93\u51fa\u6d41", notes="", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="response")})
    @RequestMapping(value={"/image/{imageId}/stream"}, produces={"application/octet-stream"}, method={RequestMethod.GET})
    public Object getImageStream(@ApiParam(value="\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid GetImageStreamRequest var2);

    @ApiOperation(value="\u5355\u636e\u5185\u8865\u626b(\u53ea\u4e0a\u4f20\u56fe\u7247)", notes="\u8865\u626b\u5f71\u50cf\u8868", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u65b0\u589e\u7ed3\u679c")})
    @RequestMapping(value={"/image/insert"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse insertImage(@ApiParam(value="request", required=true) @Valid InsertImageRequest var1);

    @ApiOperation(value="\u79fb\u52a8\u5f71\u50cf", notes="\u79fb\u52a8\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ed3\u679c")})
    @RequestMapping(value={"/image/{imageId}/move"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse moveImage(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid MoveImageRequest var2);

    @ApiOperation(value="\u4e2a\u4eba\u5f71\u50cf\u65b0\u589e", notes="\u4e2a\u4eba\u5f71\u50cf\u65b0\u589e", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u65b0\u589e\u7ed3\u679c")})
    @RequestMapping(value={"/image/person"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse personSave(@ApiParam(value="request", required=true) @Valid SaveImageRequest var1);

    @ApiOperation(value="\u5c01\u9762\u66ff\u626b", notes="\u5c01\u9762\u66ff\u626b", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u64a4\u9500\u7ed3\u679c")})
    @RequestMapping(value={"/image/{billCode}/cover"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse replaceCoverImage(@ApiParam(value="request", required=true) @Valid UpdateImageRequest var1);

    @ApiOperation(value="\u64a4\u9500\u5f71\u50cf\u8986\u76d6", notes="\u64a4\u9500\u5f71\u50cf\u8986\u76d6", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u64a4\u9500\u7ed3\u679c")})
    @RequestMapping(value={"/image/{imageId}/reset"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse resetImage(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid BaseRequest var2);

    @ApiOperation(value="\u6807\u8bb0\u5f71\u50cf\u4e3a\u9000\u56de\u72b6\u6001", notes="\u6807\u8bb0\u5f71\u50cf\u4e3a\u9000\u56de\u72b6\u6001", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ed3\u679c")})
    @RequestMapping(value={"/image/return"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse returnImage(@ApiParam(value="request", required=true) @Valid ReturnImageRequest var1);

    @ApiOperation(value="\u65cb\u8f6c\u5f71\u50cf", notes="\u65cb\u8f6c\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u64a4\u9500\u7ed3\u679c")})
    @RequestMapping(value={"/image/{imageId}/rotateImage"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse rotateImage(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid RotateImageRequest var2);

    @ApiOperation(value="\u65b0\u589e\u5f71\u50cf\u8868", notes="\u65b0\u589e\u5f71\u50cf\u8868", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u65b0\u589e\u7ed3\u679c")})
    @RequestMapping(value={"/image"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse saveImage(@ApiParam(value="request", required=true) @Valid SaveImageRequest var1);

    @ApiOperation(value="\u6839\u636e\u5f71\u50cfID\u548cbase64\u8986\u76d6\u5f71\u50cf\u6216\u521b\u5efa\u526f\u672c", notes="\u6839\u636e\u5f71\u50cfID\u548cbase64\u8986\u76d6\u5f71\u50cf\u6216\u521b\u5efa\u526f\u672c", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u66f4\u65b0\u7ed3\u679c")})
    @RequestMapping(value={"/image/{imageId}/base64"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse saveImageOrCopyByBase64(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid SaveImageOrCopyRequest var2);

    @ApiOperation(value="\u8131\u6302\u5f71\u50cf", notes="\u8131\u6302\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u8131\u6302\u7ed3\u679c")})
    @RequestMapping(value={"/image/unhook"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse unhookImage(@ApiParam(value="request", required=true) @Valid BillSelectAllRequest var1);

    @ApiOperation(value="\u4e2a\u4eba\u5355\u8bc1\u6c60\u4e0a\u4f20(\u53ea\u4e0a\u4f20\u56fe\u7247)", notes="\u4e2a\u4eba\u5355\u8bc1\u6c60\u4e0a\u4f20(\u53ea\u4e0a\u4f20\u56fe\u7247)", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u4e0a\u4f20\u7ed3\u679c")})
    @RequestMapping(value={"/image/upload"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse upload(@ApiParam(value="request", required=true) @Valid UploadRequest var1);

    @ApiOperation(value="\u5355\u636e\u5185\u8865\u4e0a\u4f20(\u56fe\u7247\u3001\u6587\u4ef6)", notes="\u8865\u626b\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u65b0\u589e\u7ed3\u679c")})
    @RequestMapping(value={"/image/insertBillImage"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse insertBillImage(@ApiParam(value="request", required=true) @Valid InsertBillImageRequest var1);

    @ApiOperation(value="\u4e0a\u4f20\u62e6\u622a\u6587\u6848", notes="\u4e0a\u4f20\u62e6\u622a\u6587\u6848", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6587\u6848")})
    @RequestMapping(value={"/image/uploadMessage"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse uploadMessage(@ApiParam(value="request", required=true) @Valid BaseRequest var1);

    @ApiOperation(value="\u5207\u5272\u5f71\u50cf")
    @PostMapping(value={"/image/cutImage"})
    public CommonResponse<Long> cutImage(@ApiParam(value="request", required=true) @RequestBody CutImageRequest var1);

    @ApiOperation(value="\u91cd\u65b0\u8f6c\u6362", notes="\u91cd\u65b0\u8f6c\u6362", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6587\u6848")})
    @RequestMapping(value={"/image/reTransfromImage"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse reTransfromImage(@ApiParam(value="request", required=true) @RequestBody BillSelectAllRequest var1);

    @ApiOperation(value="\u4e0a\u4f20\u9644\u4ef6", notes="\u4e0a\u4f20\u9644\u4ef6", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u4e0a\u4f20\u7ed3\u679c")})
    @RequestMapping(value={"/image/uploadAttachment"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse uploadAttachment(@ApiParam(value="request", required=true) @RequestBody UploadRequest var1);

    @ApiOperation(value="\u6e90\u6587\u4ef6\u4e0a\u4f20", notes="\u6e90\u6587\u4ef6\u4e0a\u4f20", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u6e90\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c")})
    @RequestMapping(value={"/image/sourceFileUpload"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse sourceFileUpload(@ApiParam(value="request", required=true) @RequestBody SourceFileUploadRequest var1);

    @ApiOperation(value="\u83b7\u53d6\u5c01\u9762\u5f71\u50cf", notes="\u83b7\u53d6\u5c01\u9762\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u7ed3\u679c")})
    @RequestMapping(value={"/image/getCoverImageList"}, produces={"application/json"}, method={RequestMethod.GET})
    public CommonResponse getCoverImageList(@ApiParam(value="request", required=true) @Valid GetCoverImageListRequest var1);

    @ApiOperation(value="\u5c01\u9762\u4e0a\u4f20", notes="\u5c01\u9762\u4e0a\u4f20", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u64a4\u9500\u7ed3\u679c")})
    @RequestMapping(value={"/image/saveCoverImage"}, produces={"application/json"}, method={RequestMethod.POST})
    public CommonResponse saveCoverImage(@ApiParam(value="request", required=true) @Valid SaveImageRequest var1);

    @ApiOperation(value="\u5220\u9664\u5c01\u9762\u5f71\u50cf", notes="\u5220\u9664\u5c01\u9762\u5f71\u50cf", authorizations={@Authorization(value="X-Access-Token"), @Authorization(value="X-Operation-Token")})
    @ApiResponses(value={@ApiResponse(code=200, message="\u64a4\u9500\u7ed3\u679c")})
    @RequestMapping(value={"/image/{imageId}/deleteCoverImage"}, produces={"application/json"}, method={RequestMethod.PUT})
    public CommonResponse deleteCoverImage(@ApiParam(value="\u81ea\u589e\u4e3b\u952e", required=true) @PathVariable(value="imageId") Long var1, @ApiParam(value="request", required=true) @Valid BaseRequest var2);
}

