/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.emo.rabbit;

import com.xforceplus.emo.rabbit.MqExceptionEntity;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MqErrorHandler
implements RabbitListenerErrorHandler {
    private static Logger logger = LoggerFactory.getLogger(MqErrorHandler.class);

    @Transactional(rollbackFor={Exception.class})
    public Object handleError(org.springframework.amqp.core.Message amqpMessage, Message<?> message, ListenerExecutionFailedException exception) {
        MqExceptionEntity record = new MqExceptionEntity();
        record.setMessageId(message.getHeaders().getId().toString());
        record.setExchangeName(amqpMessage.getMessageProperties().getReceivedExchange());
        record.setRoutingKey(amqpMessage.getMessageProperties().getReceivedRoutingKey());
        record.setMsgContent(new String(amqpMessage.getBody()));
        record.setMsgHeader(MqErrorHandler.toJsonString(amqpMessage.getMessageProperties().getHeaders()));
        record.setRemark(ExceptionUtils.getStackTrace((Throwable)exception));
        logger.error("\u961f\u5217\u5904\u7406\u53d1\u751f\u5f02\u5e38:{}", (Object)record.toString());
        return null;
    }

    private static String toJsonString(Object object) {
        String jsonStr = "";
        try {
            jsonStr = object.toString();
        }
        catch (Exception var3) {
            logger.error("error", (Throwable)var3);
        }
        return jsonStr;
    }
}

