/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.emo.rabbit;

import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMq;
import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import io.arivera.oss.embedded.rabbitmq.PredefinedVersion;
import io.arivera.oss.embedded.rabbitmq.Version;
import io.arivera.oss.embedded.rabbitmq.bin.RabbitMqPlugins;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfiguration {
    private static final long INTIAL_TIMEOUT = 60000L;
    private static final long DOWNLOAD_READ_TIMEOUT = 30000L;
    private static final long RABBITMQ_CTL_TIMEOUT = 30000L;
    private static final long ERLANG_CHECK_TIMEOUT = 30000L;
    private static final String RABBITMQ_MANAGEMENT_PLUGIN = "rabbitmq_management";

    @Bean(name={"embedded-broker"}, destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"xplat.innermq.enabled"}, havingValue="true")
    public EmbeddedRabbitMq embeddedRabbitMq() {
        EmbeddedRabbitMqConfig.Builder configBuilder = new EmbeddedRabbitMqConfig.Builder();
        EmbeddedRabbitMqConfig config = configBuilder.version((Version)PredefinedVersion.V3_7_7).rabbitMqServerInitializationTimeoutInMillis(60000L).downloadReadTimeoutInMillis(30000L).defaultRabbitMqCtlTimeoutInMillis(30000L).erlangCheckTimeoutInMillis(30000L).useCachedDownload(true).port(5672).build();
        EmbeddedRabbitMq rabbitMq = new EmbeddedRabbitMq(config);
        RabbitMqPlugins rabbitMqPlugins = new RabbitMqPlugins(config);
        rabbitMqPlugins.enable(RABBITMQ_MANAGEMENT_PLUGIN);
        rabbitMq.start();
        return rabbitMq;
    }
}

