/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.emo.rabbit;

import com.xforceplus.emo.rabbit.RabbitMQConfig;
import com.xforceplus.emo.rabbit.RabbitmqConstants;
import com.xforceplus.emo.rabbit.RabbitmqQueue;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqInitListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private RabbitTemplate rabbitTemplate;
    private RabbitMQConfig rabbitMQConfig;
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqInitListener.class);

    @Autowired
    public RabbitMqInitListener(RabbitTemplate rabbitTemplate, RabbitMQConfig rabbitMQConfig) {
        this.rabbitTemplate = rabbitTemplate;
        this.rabbitMQConfig = rabbitMQConfig;
    }

    public void onApplicationEvent(ApplicationPreparedEvent applicationPreparedEvent) {
    }

    private CachingConnectionFactory getConnectionFactory() {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory(this.rabbitMQConfig.address, Integer.parseInt(this.rabbitMQConfig.port));
        cachingConnectionFactory.setUsername(this.rabbitMQConfig.username);
        cachingConnectionFactory.setPassword(this.rabbitMQConfig.password);
        cachingConnectionFactory.setVirtualHost(this.rabbitMQConfig.mqRabbitVirtualHost);
        return cachingConnectionFactory;
    }

    public void init() {
        DirectExchange directExchange = new DirectExchange(RabbitmqConstants.DIRECT_EXCHANGE);
        TopicExchange topicExchange = new TopicExchange(RabbitmqConstants.TOPIC_EXCHANGE);
        FanoutExchange fanoutExchange = new FanoutExchange(RabbitmqConstants.FANOUT_EXCHANGE);
        logger.info("rabbitmq initial configuration start");
        List<RabbitmqQueue> queues = this.rabbitMQConfig.getQueues();
        if (queues != null && queues.size() != 0) {
            CachingConnectionFactory cachingConnectionFactory = this.getConnectionFactory();
            RabbitAdmin admin = new RabbitAdmin((ConnectionFactory)cachingConnectionFactory);
            admin.declareExchange((Exchange)directExchange);
            admin.declareExchange((Exchange)topicExchange);
            admin.declareExchange((Exchange)fanoutExchange);
            this.rabbitTemplate = admin.getRabbitTemplate();
            for (RabbitmqQueue rq : queues) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (rq.getPriority() != null) {
                    map.put("x-max-priority", Integer.parseInt(rq.getPriority()));
                }
                if (!"rkey.direct.deadmsg".equals(rq.getRoutingKey()) && null != rq.getExpires()) {
                    map.put("x-dead-letter-exchange", RabbitmqConstants.DIRECT_EXCHANGE);
                    map.put("x-dead-letter-routing-key", "rkey.direct.deadmsg");
                }
                Queue queue = new Queue(rq.getName(), rq.getDurable(), rq.getExclusive(), rq.getAutoDelete(), map);
                admin.declareQueue(queue);
                if (RabbitmqConstants.DIRECT_EXCHANGE.equals(rq.getExchangeName())) {
                    admin.declareBinding(BindingBuilder.bind((Queue)queue).to(directExchange).with(rq.getRoutingKey()));
                    continue;
                }
                if (RabbitmqConstants.TOPIC_EXCHANGE.equals(rq.getExchangeName())) {
                    admin.declareBinding(BindingBuilder.bind((Queue)queue).to(topicExchange).with(rq.getRoutingKey()));
                    continue;
                }
                if (!RabbitmqConstants.FANOUT_EXCHANGE.equals(rq.getExchangeName())) continue;
                admin.declareBinding(BindingBuilder.bind((Queue)queue).to(fanoutExchange));
            }
        }
        logger.info("Rabbitmq initial configuration completed");
    }
}

