/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.emo.rabbit;

import com.xforceplus.emo.rabbit.RabbitMQConfig;
import com.xforceplus.emo.rabbit.RabbitmqConstants;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqService {
    private final Logger logger = LoggerFactory.getLogger(RabbitmqService.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitMQConfig rabbitMQConfig;

    public void sendByDirectExchange(String routingKey, Object msg) {
        this.send(RabbitmqConstants.DIRECT_EXCHANGE, routingKey, msg, null, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, int priority) {
        this.send(RabbitmqConstants.DIRECT_EXCHANGE, routingKey, msg, priority, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, String expires) {
        this.send(RabbitmqConstants.DIRECT_EXCHANGE, routingKey, msg, null, expires);
    }

    public void sendByDirectExchange(String routingKey, Object msg, int priority, String expires) {
        this.send(RabbitmqConstants.DIRECT_EXCHANGE, routingKey, msg, priority, expires);
    }

    public void sendByTopicExchange(String routingKey, Object msg) {
        this.send(RabbitmqConstants.TOPIC_EXCHANGE, routingKey, msg, null, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, int priority) {
        this.send(RabbitmqConstants.TOPIC_EXCHANGE, routingKey, msg, priority, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, String expires) {
        this.send(RabbitmqConstants.TOPIC_EXCHANGE, routingKey, msg, null, expires);
    }

    public void sendByTopicExchange(String routingKey, Object msg, int priority, String expires) {
        this.send(RabbitmqConstants.TOPIC_EXCHANGE, routingKey, msg, priority, expires);
    }

    public void sendByFanoutExchange(Object msg) {
        this.send(RabbitmqConstants.FANOUT_EXCHANGE, null, msg, null, null);
    }

    public void sendByFanoutExchange(Object msg, int priority) {
        this.send(RabbitmqConstants.FANOUT_EXCHANGE, null, msg, priority, null);
    }

    public void sendByFanoutExchange(Object msg, String expires) {
        this.send(RabbitmqConstants.FANOUT_EXCHANGE, null, msg, null, expires);
    }

    public void sendByFanoutExchange(Object msg, int priority, String expires) {
        this.send(RabbitmqConstants.FANOUT_EXCHANGE, null, msg, priority, expires);
    }

    public void send(String exchange, String routingKey, Object msg, Integer priority, String expires) {
        this.rabbitTemplate.convertAndSend(exchange, routingKey, msg, message -> {
            if (null != priority) {
                message.getMessageProperties().setPriority(priority);
            }
            if (null != expires) {
                message.getMessageProperties().setExpiration(expires);
            }
            return message;
        });
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void send(String routingKey, String msg, Map<String, Object> headers) {
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.getHeaders().putAll(headers);
        Message message = new Message(msg.getBytes(), messageProperties);
        this.rabbitTemplate.send(routingKey, message);
    }

    public void convertAndSend(String routingKey, String msg) {
        this.rabbitTemplate.convertAndSend(routingKey, (Object)msg);
    }
}

