/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.emo.sqs;

import com.xforceplus.emo.constant.PhoenixConstants;
import com.xforceplus.xplat.aws.sqs.SqsService;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import org.apache.commons.lang3.StringUtils;

public class SQSSender {
    private static final String QUEUE_PREFIX = "xplat.aws.sqs.receiver.queueName.prefix";

    public static Result sendStrMsg(String queueName, String message, Map<String, String> properties, boolean prefix) {
        return prefix ? SQSSender.sendStrMsg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX)) : SQSSender.sendStrMsg(queueName, message, properties, "");
    }

    public static Result sendItBusHighStrMsg(String message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_HIGH;
        return prefix ? SQSSender.sendStrMsg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX)) : SQSSender.sendStrMsg(queueName, message, properties, "");
    }

    public static Result sendItBusMediumStrMsg(String message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_MEDIUM;
        return prefix ? SQSSender.sendStrMsg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX)) : SQSSender.sendStrMsg(queueName, message, properties, "");
    }

    public static Result sendItBusLowStrMsg(String message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_LOW;
        return prefix ? SQSSender.sendStrMsg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX)) : SQSSender.sendStrMsg(queueName, message, properties, "");
    }

    public static Result sendStrMsg(String queueName, String message, Map<String, String> properties, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            queueName = prefix + queueName;
        }
        return SqsService.getInstThread().sendStrMsg(queueName, message, properties);
    }

    public static Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties, boolean prefix) {
        if (prefix) {
            SQSSender.sendBase64Msg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return SQSSender.sendBase64Msg(queueName, message, properties, "");
    }

    public static Result sendItBusHighBase64Msg(byte[] message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_HIGH;
        if (prefix) {
            SQSSender.sendBase64Msg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return SQSSender.sendBase64Msg(queueName, message, properties, "");
    }

    public static Result sendItBusMediumBase64Msg(byte[] message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_MEDIUM;
        if (prefix) {
            SQSSender.sendBase64Msg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return SQSSender.sendBase64Msg(queueName, message, properties, "");
    }

    public static Result sendItBusLowBase64Msg(byte[] message, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_LOW;
        if (prefix) {
            SQSSender.sendBase64Msg(queueName, message, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return SQSSender.sendBase64Msg(queueName, message, properties, "");
    }

    public static Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            queueName = prefix + queueName;
        }
        return SqsService.getInstThread().sendBase64Msg(queueName, message, properties);
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties, boolean prefix) {
        if (prefix) {
            this.sendByteMsg(queueName, msgBytes, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return this.sendByteMsg(queueName, msgBytes, properties, "");
    }

    public Result sendItBusHighByteMsg(byte[] msgBytes, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_HIGH;
        if (prefix) {
            this.sendByteMsg(queueName, msgBytes, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return this.sendByteMsg(queueName, msgBytes, properties, "");
    }

    public Result sendItBusMediumByteMsg(byte[] msgBytes, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_MEDIUM;
        if (prefix) {
            this.sendByteMsg(queueName, msgBytes, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return this.sendByteMsg(queueName, msgBytes, properties, "");
    }

    public Result sendItBusLowByteMsg(byte[] msgBytes, Map<String, String> properties, boolean prefix) {
        String queueName = PhoenixConstants.IT_BUS_PRIORITY_LOW;
        if (prefix) {
            this.sendByteMsg(queueName, msgBytes, properties, Conf.get((String)QUEUE_PREFIX));
        }
        return this.sendByteMsg(queueName, msgBytes, properties, "");
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            queueName = prefix + queueName;
        }
        return SqsService.getInstThread().sendByteMsg(queueName, msgBytes, properties);
    }
}

