/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.api.qcc;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.xforceplus.finance.dvas.common.accModel.qcc.QccResultBaseModel;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheck.TaxOweNoticeCheckResponseData;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.config.qcc.QccConfig;
import com.xforceplus.finance.dvas.common.constant.qcc.QccApiEnum;
import com.xforceplus.finance.dvas.common.constant.riskstorm.CompanySourceTypeEnum;
import com.xforceplus.finance.dvas.common.entity.company.CompanyCallLog;
import com.xforceplus.finance.dvas.common.repository.company.CompanyCallLogMapper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class QccBusinessApi {
    private static final Logger log = LoggerFactory.getLogger(QccBusinessApi.class);
    @Autowired
    private QccConfig qccConfig;
    @Resource
    private CompanyCallLogMapper companyCallLogMapper;

    public <T extends QccResultBaseModel> T getAll(QccApiEnum qccApiEnum, Map<String, String> paramMap, Class<T> responseClass, CompanyContext companyContext) {
        T result = this.get(qccApiEnum, paramMap, responseClass, companyContext);
        if (result != null && ((QccResultBaseModel)result).getPaging() != null && ((QccResultBaseModel)result).getPaging().getPageIndex() < ((QccResultBaseModel)result).getPaging().getNextPageIndex()) {
            int nextPageIndex;
            int totalPage = ((QccResultBaseModel)result).getPaging().getTotalPage();
            for (int loopIndex = nextPageIndex = ((QccResultBaseModel)result).getPaging().getNextPageIndex().intValue(); loopIndex <= totalPage; ++loopIndex) {
                paramMap.put("pageIndex", String.valueOf(loopIndex));
                T loopResult = this.get(qccApiEnum, paramMap, responseClass, companyContext);
                if (qccApiEnum == QccApiEnum.TaxOweNoticeCheck_GetList) {
                    ((TaxOweNoticeCheckResponseData)((QccResultBaseModel)result).getResult()).getData().addAll(((TaxOweNoticeCheckResponseData)((QccResultBaseModel)loopResult).getResult()).getData());
                    continue;
                }
                ((List)((QccResultBaseModel)result).getResult()).addAll((List)((QccResultBaseModel)loopResult).getResult());
            }
            ((QccResultBaseModel)result).getPaging().setPageSize(((QccResultBaseModel)result).getPaging().getTotalRecords());
        }
        return result;
    }

    public <T extends QccResultBaseModel> T get(QccApiEnum qccApiEnum, Map<String, String> paramMap, Class<? extends QccResultBaseModel> responseClass, CompanyContext companyContext) {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000L);
        String authHeader = DigestUtils.md5Hex((String)this.qccConfig.getAppKey().concat(timeSpan).concat(this.qccConfig.getSecretKey())).toUpperCase();
        String url = String.format("%s%s%s%s", this.qccConfig.getHttpUrl(), qccApiEnum.getPath(), "?key=", this.qccConfig.getAppKey());
        StringBuilder stringBuilder = new StringBuilder();
        paramMap.forEach((key, value) -> stringBuilder.append(StrUtil.format((CharSequence)"&{}={}", (Object[])new Object[]{key, value})));
        String getUlr = url.concat(stringBuilder.toString());
        log.info(StrUtil.format((CharSequence)"[\u4f01\u67e5\u67e5]-{} \u63a5\u53e3Url:{}", (Object[])new Object[]{qccApiEnum.getDesc(), url}));
        log.info(StrUtil.format((CharSequence)"[\u4f01\u67e5\u67e5]-{} \u63a5\u53e3\u53c2\u6570:{}", (Object[])new Object[]{qccApiEnum.getDesc(), stringBuilder.toString()}));
        log.info("[\u4f01\u67e5\u67e5]-\u63a5\u53e3 getUlr:{}", (Object)getUlr);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u8bf7\u6c42\u4f01\u67e5\u67e5\u5f00\u59cb");
        HttpResponse httpResponse = ((HttpRequest)((HttpRequest)HttpRequest.get((String)getUlr).header("Token", authHeader)).header("Timespan", timeSpan)).timeout(60000).setConnectionTimeout(15000).setEncodeUrlParams(true).execute();
        stopWatch.stop();
        String responseString = new String(httpResponse.bodyBytes(), Charset.forName("UTF-8"));
        log.info("[\u4f01\u67e5\u67e5]-{} \u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:", (Object)qccApiEnum.getDesc());
        log.info(responseString);
        if (httpResponse.getStatus() != 200) {
            log.warn("[\u8c03\u7528\u670d\u52a1\u54cd\u5e94\u5931\u8d25-\u8c03\u7528\u4f01\u67e5\u67e5\u63a5\u53e3\u54cd\u5e94\u5931\u8d25] response:{}", (Object)responseString);
            throw new RuntimeException("[\u4f01\u67e5\u67e5]-\u54cd\u5e94HttpStatus != 200 : " + httpResponse.getStatus());
        }
        if (qccApiEnum.getCode().equalsIgnoreCase(QccApiEnum.GetJudgementDetail.getCode())) {
            responseString = "";
        }
        this.recordLog(CompanySourceTypeEnum.QCC, qccApiEnum.getCode(), qccApiEnum.getDesc(), stringBuilder.toString(), responseString, companyContext, String.valueOf(httpResponse.getStatus()), stopWatch.getLastTaskTimeMillis());
        QccResultBaseModel result = (QccResultBaseModel)JSON.parseObject((String)responseString, responseClass);
        result.convertParam(responseString);
        return (T)result;
    }

    public void recordLog(CompanySourceTypeEnum sourceTypeEnum, String code, String desc, String paramStr, String responseString, CompanyContext companyContext, String retCode, long startTimeNanos) {
        try {
            CompanyCallLog companyCallLog = new CompanyCallLog();
            companyCallLog.setReqParam(paramStr);
            companyCallLog.setResBody(responseString);
            companyCallLog.setCompanyRecordId(Long.valueOf(companyContext.getCompanyRecordId() == null ? 0L : companyContext.getCompanyRecordId()));
            companyCallLog.setTaxNum(companyContext.getTaxNum() == null ? "" : companyContext.getTaxNum());
            companyCallLog.setDataSourceType(Integer.valueOf(sourceTypeEnum.getValue()));
            companyCallLog.setOperationCode(code);
            companyCallLog.setOperationName(desc);
            companyCallLog.setRetCode(retCode);
            companyCallLog.setElapseTime(Long.valueOf(startTimeNanos));
            if (companyContext.getCurrentVersion() == null) {
                companyCallLog.setCurrentVersion(Long.valueOf(0L));
            } else {
                companyCallLog.setCurrentVersion(companyContext.getCurrentVersion());
            }
            this.companyCallLogMapper.insert((Object)companyCallLog);
        }
        catch (Exception e) {
            log.error("[{}]---\u8bb0\u5f55\u8c03\u7528\u65e5\u5fd7\u5931\u8d25\uff01:{}", (Object)sourceTypeEnum.getDesc(), (Object)e);
            throw e;
        }
    }
}

