/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.convert;

import cn.hutool.json.JSONUtil;
import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.companyWebSite.CompanyWebSiteResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.ECIBranchResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.OperInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIChange.ECIChangeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIEmployee.ECIEmployeeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIInfoOverview.ECIInfoOverviewResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIPartner.ECIPartnerReponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.equityThrough.EquityThroughInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.exceptionCheck.ExceptionCheckInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgmentDoc.SearchJudgmentDocResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.searchPhone.SearchPhoneResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxCredit.TaxCreditResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheck.TaxOweNoticeCheckInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.Oper;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.TaxOweNoticeCheckDetailResponseData;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.convert.IQccDTOConvert;
import com.xforceplus.finance.dvas.common.convert.format.UtterStructFormatter;
import com.xforceplus.finance.dvas.common.dto.CompanyInfoDto;
import com.xforceplus.finance.dvas.common.dto.CompanySearchDto;
import com.xforceplus.finance.dvas.common.entity.company.CompanyBranch;
import com.xforceplus.finance.dvas.common.entity.company.CompanyChangeInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyContactInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyDetailInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyEmployeeInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyEquityThrough;
import com.xforceplus.finance.dvas.common.entity.company.CompanyException;
import com.xforceplus.finance.dvas.common.entity.company.CompanyJudgmentDoc;
import com.xforceplus.finance.dvas.common.entity.company.CompanyOverviewInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyPartner;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxOweDetailInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxOweInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyWebSite;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IQccDTOConvertImpl
implements IQccDTOConvert {
    @Autowired
    private UtterStructFormatter utterStructFormatter;

    @Override
    public CompanyDetailInfo toCompanyDetailInfo(BasicDetailInfoResponseData basicDetailInfoResponseData, CompanyContext companyContext) {
        if (basicDetailInfoResponseData == null && companyContext == null) {
            return null;
        }
        CompanyDetailInfo companyDetailInfo = new CompanyDetailInfo();
        if (basicDetailInfoResponseData != null) {
            companyDetailInfo.setThirdNo(basicDetailInfoResponseData.getKeyNo());
            companyDetailInfo.setName(basicDetailInfoResponseData.getName());
            companyDetailInfo.setNo(basicDetailInfoResponseData.getNo());
            companyDetailInfo.setBelongOrg(basicDetailInfoResponseData.getBelongOrg());
            companyDetailInfo.setOperName(basicDetailInfoResponseData.getOperName());
            companyDetailInfo.setStartDate(basicDetailInfoResponseData.getStartDate());
            companyDetailInfo.setEndDate(basicDetailInfoResponseData.getEndDate());
            companyDetailInfo.setStatus(basicDetailInfoResponseData.getStatus());
            companyDetailInfo.setProvince(basicDetailInfoResponseData.getProvince());
            companyDetailInfo.setUpdatedDate(basicDetailInfoResponseData.getUpdatedDate());
            companyDetailInfo.setCreditCode(basicDetailInfoResponseData.getCreditCode());
            companyDetailInfo.setRegistCapi(basicDetailInfoResponseData.getRegistCapi());
            companyDetailInfo.setEconKind(basicDetailInfoResponseData.getEconKind());
            companyDetailInfo.setAddress(basicDetailInfoResponseData.getAddress());
            companyDetailInfo.setScope(basicDetailInfoResponseData.getScope());
            companyDetailInfo.setTermStart(basicDetailInfoResponseData.getTermStart());
            companyDetailInfo.setTeamEnd(basicDetailInfoResponseData.getTeamEnd());
            companyDetailInfo.setCheckDate(basicDetailInfoResponseData.getCheckDate());
            companyDetailInfo.setOrgNo(basicDetailInfoResponseData.getOrgNo());
            companyDetailInfo.setIsOnStock(basicDetailInfoResponseData.getIsOnStock());
            companyDetailInfo.setStockNumber(basicDetailInfoResponseData.getStockNumber());
            companyDetailInfo.setStockType(basicDetailInfoResponseData.getStockType());
            companyDetailInfo.setEntType(basicDetailInfoResponseData.getEntType());
            companyDetailInfo.setRecCap(basicDetailInfoResponseData.getRecCap());
            companyDetailInfo.setOriginalName(basicDetailInfoResponseData.getOriginalName());
        }
        if (companyContext != null) {
            companyDetailInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyDetailInfo.setTaxNum(companyContext.getTaxNum());
            companyDetailInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyDetailInfo.setExt("");
        companyDetailInfo.setCreateBy("sys");
        companyDetailInfo.setCreateTime(LocalDateTime.now());
        companyDetailInfo.setUpdateBy("sys");
        companyDetailInfo.setUpdateTime(LocalDateTime.now());
        companyDetailInfo.setDataSourceType(Integer.valueOf(1));
        return companyDetailInfo;
    }

    @Override
    public CompanyPartner toCompanyPartner(ECIPartnerReponseData eciPartnerReponseData, CompanyContext companyContext) {
        if (eciPartnerReponseData == null && companyContext == null) {
            return null;
        }
        CompanyPartner companyPartner = new CompanyPartner();
        if (eciPartnerReponseData != null) {
            companyPartner.setThirdNo(eciPartnerReponseData.getKeyNo());
            companyPartner.setStockName(eciPartnerReponseData.getStockName());
            companyPartner.setStockType(eciPartnerReponseData.getStockType());
            companyPartner.setStockPercent(eciPartnerReponseData.getStockPercent());
            companyPartner.setShouldCapi(eciPartnerReponseData.getShouldCapi());
            companyPartner.setShoudDate(this.utterStructFormatter.stringToLocalDateTime(eciPartnerReponseData.getShoudDate()));
        }
        if (companyContext != null) {
            companyPartner.setTaxNum(companyContext.getTaxNum());
            companyPartner.setVersion(companyContext.getCurrentVersion());
            companyPartner.setCompanyRecordId(companyContext.getCompanyRecordId());
        }
        companyPartner.setExt("");
        companyPartner.setCreateBy("sys");
        companyPartner.setCreateTime(LocalDateTime.now());
        companyPartner.setUpdateBy("sys");
        companyPartner.setUpdateTime(LocalDateTime.now());
        companyPartner.setDataSourceType(Integer.valueOf(1));
        return companyPartner;
    }

    @Override
    public CompanyBranch toCompanyBranch(ECIBranchResponseData eciBranchResponseData, CompanyContext companyContext) {
        if (eciBranchResponseData == null && companyContext == null) {
            return null;
        }
        CompanyBranch companyBranch = new CompanyBranch();
        if (eciBranchResponseData != null) {
            companyBranch.setOperInfoThirdNo(this.eciBranchResponseDataOperInfoKeyNo(eciBranchResponseData));
            companyBranch.setThirdNo(eciBranchResponseData.getKeyNo());
            companyBranch.setOperInfoName(this.eciBranchResponseDataOperInfoName(eciBranchResponseData));
            companyBranch.setName(eciBranchResponseData.getName());
            companyBranch.setStatus(eciBranchResponseData.getStatus());
        }
        if (companyContext != null) {
            companyBranch.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyBranch.setVersion(companyContext.getCurrentVersion());
            companyBranch.setTaxNum(companyContext.getTaxNum());
        }
        companyBranch.setExt("");
        companyBranch.setUpdateTime(LocalDateTime.now());
        companyBranch.setCreateBy("sys");
        companyBranch.setCreateTime(LocalDateTime.now());
        companyBranch.setUpdateBy("sys");
        companyBranch.setDataSourceType(Integer.valueOf(1));
        return companyBranch;
    }

    @Override
    public CompanyChangeInfo toCompanyChangeInfo(ECIChangeResponseData eciChangeResponseData, CompanyContext companyContext) {
        if (eciChangeResponseData == null && companyContext == null) {
            return null;
        }
        CompanyChangeInfo companyChangeInfo = new CompanyChangeInfo();
        if (eciChangeResponseData != null) {
            companyChangeInfo.setProjectName(eciChangeResponseData.getProjectName());
            if (eciChangeResponseData.getChangeDate() != null) {
                companyChangeInfo.setChangeDate(LocalDateTime.ofInstant(eciChangeResponseData.getChangeDate().toInstant(), ZoneId.of("UTC")));
            }
        }
        if (companyContext != null) {
            companyChangeInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyChangeInfo.setVersion(companyContext.getCurrentVersion());
            companyChangeInfo.setTaxNum(companyContext.getTaxNum());
        }
        companyChangeInfo.setExt("");
        companyChangeInfo.setAfterList(JSONUtil.toJsonStr(eciChangeResponseData.getAfterList()));
        companyChangeInfo.setUpdateTime(LocalDateTime.now());
        companyChangeInfo.setCreateBy("sys");
        companyChangeInfo.setCreateTime(LocalDateTime.now());
        companyChangeInfo.setUpdateBy("sys");
        companyChangeInfo.setBeforeList(JSONUtil.toJsonStr(eciChangeResponseData.getBeforeList()));
        companyChangeInfo.setBeforeInfoList(JSONUtil.toJsonStr(eciChangeResponseData.getBeforeInfoList()));
        companyChangeInfo.setAfterInfoList(JSONUtil.toJsonStr(eciChangeResponseData.getAfterInfoList()));
        companyChangeInfo.setDataSourceType(Integer.valueOf(1));
        return companyChangeInfo;
    }

    @Override
    public CompanyEmployeeInfo toCompanyEmployeeInfo(ECIEmployeeResponseData eciEmployeeResponseData, CompanyContext companyContext) {
        if (eciEmployeeResponseData == null && companyContext == null) {
            return null;
        }
        CompanyEmployeeInfo companyEmployeeInfo = new CompanyEmployeeInfo();
        if (eciEmployeeResponseData != null) {
            companyEmployeeInfo.setThirdNo(eciEmployeeResponseData.getKeyNo());
            companyEmployeeInfo.setName(eciEmployeeResponseData.getName());
            companyEmployeeInfo.setJob(eciEmployeeResponseData.getJob());
        }
        if (companyContext != null) {
            companyEmployeeInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyEmployeeInfo.setTaxNum(companyContext.getTaxNum());
            companyEmployeeInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyEmployeeInfo.setExt("");
        companyEmployeeInfo.setCreateBy("sys");
        companyEmployeeInfo.setCreateTime(LocalDateTime.now());
        companyEmployeeInfo.setUpdateBy("sys");
        companyEmployeeInfo.setUpdateTime(LocalDateTime.now());
        companyEmployeeInfo.setDataSourceType(Integer.valueOf(1));
        return companyEmployeeInfo;
    }

    @Override
    public CompanyEquityThrough toCompanyEquityThrough(EquityThroughInfo equityThroughInfo, CompanyContext companyContext) {
        if (equityThroughInfo == null && companyContext == null) {
            return null;
        }
        CompanyEquityThrough companyEquityThrough = new CompanyEquityThrough();
        if (equityThroughInfo != null) {
            companyEquityThrough.setThirdNo(equityThroughInfo.getKeyNo());
            companyEquityThrough.setName(equityThroughInfo.getName());
            companyEquityThrough.setCategory(equityThroughInfo.getCategory());
            companyEquityThrough.setFundedRatio(equityThroughInfo.getFundedRatio());
            companyEquityThrough.setInParentActualRadio(equityThroughInfo.getInParentActualRadio());
            companyEquityThrough.setCount(equityThroughInfo.getCount());
            companyEquityThrough.setGrade(equityThroughInfo.getGrade());
            companyEquityThrough.setShouldCapi(equityThroughInfo.getShouldCapi());
            companyEquityThrough.setStockRightNum(equityThroughInfo.getStockRightNum());
            companyEquityThrough.setShortStatus(equityThroughInfo.getShortStatus());
        }
        if (companyContext != null) {
            companyEquityThrough.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyEquityThrough.setTaxNum(companyContext.getTaxNum());
            companyEquityThrough.setVersion(companyContext.getCurrentVersion());
        }
        companyEquityThrough.setExt(JSONUtil.toJsonStr((Object)equityThroughInfo.getChildren()));
        companyEquityThrough.setCreateBy("sys");
        companyEquityThrough.setCreateTime(LocalDateTime.now());
        companyEquityThrough.setUpdateBy("sys");
        companyEquityThrough.setUpdateTime(LocalDateTime.now());
        companyEquityThrough.setDataSourceType(Integer.valueOf(1));
        return companyEquityThrough;
    }

    @Override
    public CompanyException toCompanyException(ExceptionCheckInfo exceptionCheckInfo, CompanyContext companyContext) {
        if (exceptionCheckInfo == null && companyContext == null) {
            return null;
        }
        CompanyException companyException = new CompanyException();
        if (exceptionCheckInfo != null) {
            if (exceptionCheckInfo.getRemoveDate() != null) {
                companyException.setRemoveDate(LocalDateTime.ofInstant(exceptionCheckInfo.getRemoveDate().toInstant(), ZoneId.of("UTC")));
            }
            companyException.setDecisionOffice(exceptionCheckInfo.getDecisionOffice());
            if (exceptionCheckInfo.getAddDate() != null) {
                companyException.setAddDate(LocalDateTime.ofInstant(exceptionCheckInfo.getAddDate().toInstant(), ZoneId.of("UTC")));
            }
            companyException.setRemoveDecisionOffice(exceptionCheckInfo.getRemoveDecisionOffice());
            companyException.setRomoveReason(exceptionCheckInfo.getRomoveReason());
            companyException.setAddReason(exceptionCheckInfo.getAddReason());
        }
        if (companyContext != null) {
            companyException.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyException.setVersion(companyContext.getCurrentVersion());
            companyException.setTaxNum(companyContext.getTaxNum());
        }
        companyException.setExt("");
        companyException.setUpdateTime(LocalDateTime.now());
        companyException.setCreateBy("sys");
        companyException.setCreateTime(LocalDateTime.now());
        companyException.setUpdateBy("sys");
        companyException.setDataSourceType(Integer.valueOf(1));
        return companyException;
    }

    @Override
    public CompanyTaxOweInfo toCompanyTaxOweInfo(TaxOweNoticeCheckInfo taxOweNoticeCheckInfo, CompanyContext companyContext) {
        if (taxOweNoticeCheckInfo == null && companyContext == null) {
            return null;
        }
        CompanyTaxOweInfo companyTaxOweInfo = new CompanyTaxOweInfo();
        if (taxOweNoticeCheckInfo != null) {
            companyTaxOweInfo.setId(taxOweNoticeCheckInfo.getId());
            companyTaxOweInfo.setTitle(taxOweNoticeCheckInfo.getTitle());
            companyTaxOweInfo.setAmount(taxOweNoticeCheckInfo.getAmount());
            companyTaxOweInfo.setNewAmount(taxOweNoticeCheckInfo.getNewAmount());
            companyTaxOweInfo.setPublishDate(taxOweNoticeCheckInfo.getPublishDate());
            companyTaxOweInfo.setIssuedBy(taxOweNoticeCheckInfo.getIssuedBy());
        }
        if (companyContext != null) {
            companyTaxOweInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyTaxOweInfo.setTaxNum(companyContext.getTaxNum());
            companyTaxOweInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyTaxOweInfo.setExt("");
        companyTaxOweInfo.setCreateBy("sys");
        companyTaxOweInfo.setCreateTime(LocalDateTime.now());
        companyTaxOweInfo.setUpdateBy("sys");
        companyTaxOweInfo.setUpdateTime(LocalDateTime.now());
        companyTaxOweInfo.setDataSourceType(Integer.valueOf(1));
        return companyTaxOweInfo;
    }

    @Override
    public CompanyTaxOweDetailInfo toCompanyTaxOweDetailInfo(TaxOweNoticeCheckDetailResponseData taxOweNoticeCheckDetailResponseData, CompanyContext companyContext) {
        if (taxOweNoticeCheckDetailResponseData == null && companyContext == null) {
            return null;
        }
        CompanyTaxOweDetailInfo companyTaxOweDetailInfo = new CompanyTaxOweDetailInfo();
        if (taxOweNoticeCheckDetailResponseData != null) {
            companyTaxOweDetailInfo.setOperThirdNo(this.taxOweNoticeCheckDetailResponseDataOperKeyNo(taxOweNoticeCheckDetailResponseData));
            companyTaxOweDetailInfo.setThirdNo(taxOweNoticeCheckDetailResponseData.getKeyNo());
            companyTaxOweDetailInfo.setOperName(this.taxOweNoticeCheckDetailResponseDataOperName(taxOweNoticeCheckDetailResponseData));
            companyTaxOweDetailInfo.setId(taxOweNoticeCheckDetailResponseData.getId());
            companyTaxOweDetailInfo.setType(taxOweNoticeCheckDetailResponseData.getType());
            companyTaxOweDetailInfo.setIdentifyNo(taxOweNoticeCheckDetailResponseData.getIdentifyNo());
            companyTaxOweDetailInfo.setIdNo(taxOweNoticeCheckDetailResponseData.getIdNo());
            companyTaxOweDetailInfo.setAddr(taxOweNoticeCheckDetailResponseData.getAddr());
            companyTaxOweDetailInfo.setCategory(taxOweNoticeCheckDetailResponseData.getCategory());
            companyTaxOweDetailInfo.setNewBal(taxOweNoticeCheckDetailResponseData.getNewBal());
            companyTaxOweDetailInfo.setIssuedBy(taxOweNoticeCheckDetailResponseData.getIssuedBy());
            if (taxOweNoticeCheckDetailResponseData.getPublishDate() != null) {
                companyTaxOweDetailInfo.setPublishDate(LocalDateTime.ofInstant(taxOweNoticeCheckDetailResponseData.getPublishDate().toInstant(), ZoneId.of("UTC")));
            }
            companyTaxOweDetailInfo.setBalance(taxOweNoticeCheckDetailResponseData.getBalance());
        }
        if (companyContext != null) {
            companyTaxOweDetailInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyTaxOweDetailInfo.setCompanyName(companyContext.getCompanyName());
            companyTaxOweDetailInfo.setVersion(companyContext.getCurrentVersion());
            companyTaxOweDetailInfo.setTaxNum(companyContext.getTaxNum());
        }
        companyTaxOweDetailInfo.setExt("");
        companyTaxOweDetailInfo.setUpdateTime(LocalDateTime.now());
        companyTaxOweDetailInfo.setCreateBy("sys");
        companyTaxOweDetailInfo.setCreateTime(LocalDateTime.now());
        companyTaxOweDetailInfo.setUpdateBy("sys");
        companyTaxOweDetailInfo.setDataSourceType(Integer.valueOf(1));
        return companyTaxOweDetailInfo;
    }

    @Override
    public CompanyOverviewInfo toCompanyOverviewInfo(ECIInfoOverviewResponseData overviewResponseData, CompanyContext companyContext) {
        if (overviewResponseData == null && companyContext == null) {
            return null;
        }
        CompanyOverviewInfo companyOverviewInfo = new CompanyOverviewInfo();
        if (overviewResponseData != null) {
            companyOverviewInfo.setThirdNo(overviewResponseData.getKeyNo());
            companyOverviewInfo.setPermissionInfo(overviewResponseData.getPermissionInfo());
            companyOverviewInfo.setPenalty(overviewResponseData.getPenalty());
            companyOverviewInfo.setExceptions(overviewResponseData.getExceptions());
            companyOverviewInfo.setShiXinItems(overviewResponseData.getShiXinItems());
            companyOverviewInfo.setZhiXingItems(overviewResponseData.getZhiXingItems());
            companyOverviewInfo.setLiquidation(overviewResponseData.getLiquidation());
            companyOverviewInfo.setPledge(overviewResponseData.getPledge());
            companyOverviewInfo.setSpotCheck(overviewResponseData.getSpotCheck());
            companyOverviewInfo.setCompanyTaxCreditItems(overviewResponseData.getCompanyTaxCreditItems());
            companyOverviewInfo.setCompanyProducts(overviewResponseData.getCompanyProducts());
            companyOverviewInfo.setPermissionEciInfo(overviewResponseData.getPermissionEciInfo());
            companyOverviewInfo.setPenaltyCreditChina(overviewResponseData.getPenaltyCreditChina());
            companyOverviewInfo.setPartners(overviewResponseData.getPartners());
            companyOverviewInfo.setEmployees(overviewResponseData.getEmployees());
            companyOverviewInfo.setBranches(overviewResponseData.getBranches());
            companyOverviewInfo.setChangeRecords(overviewResponseData.getChangeRecords());
            companyOverviewInfo.setContactInfo(overviewResponseData.getContactInfo());
            companyOverviewInfo.setIndustry(overviewResponseData.getIndustry());
            companyOverviewInfo.setArea(overviewResponseData.getArea());
            companyOverviewInfo.setInsuredCount(overviewResponseData.getInsuredCount());
            companyOverviewInfo.setEnglishName(overviewResponseData.getEnglishName());
            companyOverviewInfo.setPersonScope(overviewResponseData.getPersonScope());
            companyOverviewInfo.setTagList(overviewResponseData.getTagList());
            companyOverviewInfo.setEconKindCodeList(overviewResponseData.getEconKindCodeList());
            companyOverviewInfo.setName(overviewResponseData.getName());
            companyOverviewInfo.setNo(overviewResponseData.getNo());
            companyOverviewInfo.setBelongOrg(overviewResponseData.getBelongOrg());
            companyOverviewInfo.setOperName(overviewResponseData.getOperName());
            companyOverviewInfo.setStartDate(this.utterStructFormatter.stringToLocalDateTime(overviewResponseData.getStartDate()));
            companyOverviewInfo.setEndDate(this.utterStructFormatter.stringToLocalDateTime(overviewResponseData.getEndDate()));
            companyOverviewInfo.setStatus(overviewResponseData.getStatus());
            companyOverviewInfo.setProvince(overviewResponseData.getProvince());
            companyOverviewInfo.setUpdatedDate(overviewResponseData.getUpdatedDate());
            companyOverviewInfo.setCreditCode(overviewResponseData.getCreditCode());
            companyOverviewInfo.setRegistCapi(overviewResponseData.getRegistCapi());
            companyOverviewInfo.setEconKind(overviewResponseData.getEconKind());
            companyOverviewInfo.setAddress(overviewResponseData.getAddress());
            companyOverviewInfo.setScope(overviewResponseData.getScope());
            companyOverviewInfo.setTermStart(this.utterStructFormatter.stringToLocalDateTime(overviewResponseData.getTermStart()));
            companyOverviewInfo.setTeamEnd(this.utterStructFormatter.stringToLocalDateTime(overviewResponseData.getTeamEnd()));
            companyOverviewInfo.setCheckDate(this.utterStructFormatter.stringToLocalDateTime(overviewResponseData.getCheckDate()));
            companyOverviewInfo.setIsOnStock(overviewResponseData.getIsOnStock());
            companyOverviewInfo.setStockNumber(overviewResponseData.getStockNumber());
            companyOverviewInfo.setStockType(overviewResponseData.getStockType());
            companyOverviewInfo.setOriginalName(overviewResponseData.getOriginalName());
            companyOverviewInfo.setImageUrl(overviewResponseData.getImageUrl());
            companyOverviewInfo.setEntType(overviewResponseData.getEntType());
            companyOverviewInfo.setRecCap(overviewResponseData.getRecCap());
        }
        if (companyContext != null) {
            companyOverviewInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyOverviewInfo.setTaxNum(companyContext.getTaxNum());
            companyOverviewInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyOverviewInfo.setExt("");
        companyOverviewInfo.setCreateBy("sys");
        companyOverviewInfo.setCreateTime(LocalDateTime.now());
        companyOverviewInfo.setUpdateBy("sys");
        companyOverviewInfo.setUpdateTime(LocalDateTime.now());
        companyOverviewInfo.setDataSourceType(Integer.valueOf(1));
        return companyOverviewInfo;
    }

    @Override
    public CompanyJudgmentDoc toCompanyJudgmentDoc(SearchJudgmentDocResponseData searchJudgmentDocResponseData, CompanyContext companyContext) {
        if (searchJudgmentDocResponseData == null && companyContext == null) {
            return null;
        }
        CompanyJudgmentDoc companyJudgmentDoc = new CompanyJudgmentDoc();
        if (searchJudgmentDocResponseData != null) {
            companyJudgmentDoc.setId(searchJudgmentDocResponseData.getId());
            companyJudgmentDoc.setCourt(searchJudgmentDocResponseData.getCourt());
            companyJudgmentDoc.setCaseName(searchJudgmentDocResponseData.getCaseName());
            companyJudgmentDoc.setCaseNo(searchJudgmentDocResponseData.getCaseNo());
            companyJudgmentDoc.setCaseType(searchJudgmentDocResponseData.getCaseType());
            if (searchJudgmentDocResponseData.getSubmitDate() != null) {
                companyJudgmentDoc.setSubmitDate(LocalDateTime.ofInstant(searchJudgmentDocResponseData.getSubmitDate().toInstant(), ZoneId.of("UTC")));
            }
            companyJudgmentDoc.setUpdateDate(this.utterStructFormatter.stringToLocalDateTime(searchJudgmentDocResponseData.getUpdateDate()));
            companyJudgmentDoc.setIsProsecutor(searchJudgmentDocResponseData.getIsProsecutor());
            companyJudgmentDoc.setIsDefendant(searchJudgmentDocResponseData.getIsDefendant());
            companyJudgmentDoc.setCourtYear(searchJudgmentDocResponseData.getCourtYear());
            companyJudgmentDoc.setCaseRole(searchJudgmentDocResponseData.getCaseRole());
            companyJudgmentDoc.setCourtLevel(searchJudgmentDocResponseData.getCourtLevel());
            companyJudgmentDoc.setCaseReason(searchJudgmentDocResponseData.getCaseReason());
            companyJudgmentDoc.setCaseReasonType(searchJudgmentDocResponseData.getCaseReasonType());
            companyJudgmentDoc.setCourtMonth(searchJudgmentDocResponseData.getCourtMonth());
            companyJudgmentDoc.setAmount(searchJudgmentDocResponseData.getAmount());
        }
        if (companyContext != null) {
            companyJudgmentDoc.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyJudgmentDoc.setTaxNum(companyContext.getTaxNum());
            companyJudgmentDoc.setVersion(companyContext.getCurrentVersion());
        }
        companyJudgmentDoc.setExt("");
        companyJudgmentDoc.setCreateBy("sys");
        companyJudgmentDoc.setCreateTime(LocalDateTime.now());
        companyJudgmentDoc.setUpdateBy("sys");
        companyJudgmentDoc.setUpdateTime(LocalDateTime.now());
        companyJudgmentDoc.setDataSourceType(Integer.valueOf(1));
        return companyJudgmentDoc;
    }

    @Override
    public CompanyWebSite toCompanyWebSite(CompanyWebSiteResponseData companyWebSiteResponseData, CompanyContext companyContext) {
        if (companyWebSiteResponseData == null && companyContext == null) {
            return null;
        }
        CompanyWebSite companyWebSite = new CompanyWebSite();
        if (companyWebSiteResponseData != null) {
            companyWebSite.setThirdNo(companyWebSiteResponseData.getKeyNo());
            companyWebSite.setHomeSite(companyWebSiteResponseData.getHomeSite());
            companyWebSite.setStatus(companyWebSiteResponseData.getStatus());
            companyWebSite.setTypeName(companyWebSiteResponseData.getTypeName());
            companyWebSite.setYuMing(companyWebSiteResponseData.getYuMing());
            companyWebSite.setBeiAn(companyWebSiteResponseData.getBeiAn());
            companyWebSite.setTitle(companyWebSiteResponseData.getTitle());
        }
        if (companyContext != null) {
            companyWebSite.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyWebSite.setCompanyName(companyContext.getCompanyName());
            companyWebSite.setVersion(companyContext.getCurrentVersion());
            companyWebSite.setTaxNum(companyContext.getTaxNum());
        }
        companyWebSite.setExt("");
        companyWebSite.setUpdateTime(LocalDateTime.now());
        companyWebSite.setCreateBy("sys");
        companyWebSite.setCreateTime(LocalDateTime.now());
        companyWebSite.setUpdateBy("sys");
        companyWebSite.setDataSourceType(Integer.valueOf(1));
        return companyWebSite;
    }

    @Override
    public CompanyTaxInfo toCompanyTaxInfo(TaxCreditResponseData taxCreditResponseData, CompanyContext companyContext) {
        if (taxCreditResponseData == null && companyContext == null) {
            return null;
        }
        CompanyTaxInfo companyTaxInfo = new CompanyTaxInfo();
        if (taxCreditResponseData != null) {
            companyTaxInfo.setName(taxCreditResponseData.getName());
            companyTaxInfo.setYear(taxCreditResponseData.getYear());
            companyTaxInfo.setLevel(taxCreditResponseData.getLevel());
            companyTaxInfo.setOrg(taxCreditResponseData.getOrg());
        }
        if (companyContext != null) {
            companyTaxInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyTaxInfo.setTaxNum(companyContext.getTaxNum());
            companyTaxInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyTaxInfo.setExt("");
        companyTaxInfo.setCreateBy("sys");
        companyTaxInfo.setCreateTime(LocalDateTime.now());
        companyTaxInfo.setUpdateBy("sys");
        companyTaxInfo.setUpdateTime(LocalDateTime.now());
        companyTaxInfo.setDataSourceType(Integer.valueOf(1));
        return companyTaxInfo;
    }

    @Override
    public CompanyContactInfo toCompanyContactInfo(SearchPhoneResponseData searchPhoneResponseData, CompanyContext companyContext) {
        if (searchPhoneResponseData == null && companyContext == null) {
            return null;
        }
        CompanyContactInfo companyContactInfo = new CompanyContactInfo();
        if (searchPhoneResponseData != null) {
            companyContactInfo.setThirdNo(searchPhoneResponseData.getKeyNo());
            companyContactInfo.setName(searchPhoneResponseData.getName());
            companyContactInfo.setOperName(searchPhoneResponseData.getOperName());
            if (searchPhoneResponseData.getStartDate() != null) {
                companyContactInfo.setStartDate(LocalDateTime.ofInstant(searchPhoneResponseData.getStartDate().toInstant(), ZoneId.of("UTC")));
            }
            companyContactInfo.setStatus(searchPhoneResponseData.getStatus());
            companyContactInfo.setNo(searchPhoneResponseData.getNo());
            companyContactInfo.setCreditCode(searchPhoneResponseData.getCreditCode());
            companyContactInfo.setProvince(searchPhoneResponseData.getProvince());
            if (searchPhoneResponseData.getUpdatedDate() != null) {
                companyContactInfo.setUpdatedDate(LocalDateTime.ofInstant(searchPhoneResponseData.getUpdatedDate().toInstant(), ZoneId.of("UTC")));
            }
            companyContactInfo.setRegistCapi(searchPhoneResponseData.getRegistCapi());
            companyContactInfo.setContactNumber(searchPhoneResponseData.getContactNumber());
        }
        if (companyContext != null) {
            companyContactInfo.setCompanyRecordId(companyContext.getCompanyRecordId());
            companyContactInfo.setTaxNum(companyContext.getTaxNum());
            companyContactInfo.setVersion(companyContext.getCurrentVersion());
        }
        companyContactInfo.setExt("");
        companyContactInfo.setCreateBy("sys");
        companyContactInfo.setCreateTime(LocalDateTime.now());
        companyContactInfo.setUpdateBy("sys");
        companyContactInfo.setUpdateTime(LocalDateTime.now());
        companyContactInfo.setDataSourceType(Integer.valueOf(1));
        return companyContactInfo;
    }

    @Override
    public CompanyInfoDto toThirdCompanyInfoDto(BasicDetailInfoResponseData data) {
        if (data == null) {
            return null;
        }
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        companyInfoDto.setName(data.getName());
        companyInfoDto.setNo(data.getNo());
        companyInfoDto.setBelongOrg(data.getBelongOrg());
        companyInfoDto.setOperName(data.getOperName());
        companyInfoDto.setStartDate(this.datesub(data.getStartDate()));
        companyInfoDto.setEndDate(this.datesub(data.getEndDate()));
        companyInfoDto.setStatus(data.getStatus());
        companyInfoDto.setProvince(data.getProvince());
        companyInfoDto.setCreditCode(data.getCreditCode());
        companyInfoDto.setRegistCapi(data.getRegistCapi());
        companyInfoDto.setEconKind(data.getEconKind());
        companyInfoDto.setAddress(data.getAddress());
        companyInfoDto.setScope(data.getScope());
        companyInfoDto.setTermStart(this.datesub(data.getTermStart()));
        companyInfoDto.setTeamEnd(this.datesub(data.getTeamEnd()));
        companyInfoDto.setCheckDate(this.datesub(data.getCheckDate()));
        companyInfoDto.setOriginalName(this.originalName(data.getOriginalName()));
        return companyInfoDto;
    }

    @Override
    public CompanySearchDto toThirdCompanySearchDto(SearchPhoneResponseData data) {
        if (data == null) {
            return null;
        }
        CompanySearchDto companySearchDto = new CompanySearchDto();
        companySearchDto.setName(data.getName());
        companySearchDto.setNo(data.getNo());
        if (data.getStartDate() != null) {
            companySearchDto.setStartDate(new SimpleDateFormat("yyyy-MM-dd").format(data.getStartDate()));
        }
        companySearchDto.setStatus(data.getStatus());
        companySearchDto.setCreditCode(data.getCreditCode());
        companySearchDto.setOriginalName(Collections.emptyList());
        companySearchDto.setBelongOrg("");
        return companySearchDto;
    }

    @Override
    public List<CompanySearchDto> toThirdCompanySearchDtos(List<SearchPhoneResponseData> datas) {
        if (datas == null) {
            return null;
        }
        ArrayList<CompanySearchDto> list = new ArrayList<CompanySearchDto>(datas.size());
        for (SearchPhoneResponseData searchPhoneResponseData : datas) {
            list.add(this.toThirdCompanySearchDto(searchPhoneResponseData));
        }
        return list;
    }

    private String eciBranchResponseDataOperInfoKeyNo(ECIBranchResponseData eCIBranchResponseData) {
        if (eCIBranchResponseData == null) {
            return null;
        }
        OperInfo operInfo = eCIBranchResponseData.getOperInfo();
        if (operInfo == null) {
            return null;
        }
        String keyNo = operInfo.getKeyNo();
        if (keyNo == null) {
            return null;
        }
        return keyNo;
    }

    private String eciBranchResponseDataOperInfoName(ECIBranchResponseData eCIBranchResponseData) {
        if (eCIBranchResponseData == null) {
            return null;
        }
        OperInfo operInfo = eCIBranchResponseData.getOperInfo();
        if (operInfo == null) {
            return null;
        }
        String name = operInfo.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String taxOweNoticeCheckDetailResponseDataOperKeyNo(TaxOweNoticeCheckDetailResponseData taxOweNoticeCheckDetailResponseData) {
        if (taxOweNoticeCheckDetailResponseData == null) {
            return null;
        }
        Oper oper = taxOweNoticeCheckDetailResponseData.getOper();
        if (oper == null) {
            return null;
        }
        String keyNo = oper.getKeyNo();
        if (keyNo == null) {
            return null;
        }
        return keyNo;
    }

    private String taxOweNoticeCheckDetailResponseDataOperName(TaxOweNoticeCheckDetailResponseData taxOweNoticeCheckDetailResponseData) {
        if (taxOweNoticeCheckDetailResponseData == null) {
            return null;
        }
        Oper oper = taxOweNoticeCheckDetailResponseData.getOper();
        if (oper == null) {
            return null;
        }
        String name = oper.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

