/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.xforceplus.tower.storage.StorageFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);
    private Long userId = 0L;
    @Value(value="${ucenter.tenantId}")
    private long tenantId;
    @Value(value="${oss.endpoint}")
    private String endpoint;
    @Value(value="${oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.bucket}")
    private String bucket;
    @Autowired
    private StorageFactory storageFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadOssFileToLocal(String ossFilePath, String localFileFath) {
        OSS ossClient = null;
        try {
            ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
            File file = new File(localFileFath);
            ossClient.getObject(new GetObjectRequest(this.bucket, ossFilePath), file);
        }
        catch (Exception e) {
            log.warn("[oss\u6587\u4ef6\u4e0b\u8f7d\u5230\u672c\u5730\u5f02\u5e38] e:{}", (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
    }

    public InputStream downloadInputStream(Long fileId) throws IOException {
        log.info("userId:{},tenantId:{},fileId:{}", new Object[]{this.userId, this.tenantId, fileId});
        InputStream inputStream = this.storageFactory.downloadInputStream(this.userId, Long.valueOf(this.tenantId), fileId, "");
        return inputStream;
    }
}

