/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.abc;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpUtil;
import com.abchina.ibank.uip.ABCApi;
import com.abchina.ibank.uip.eloan.apply.BillDto;
import com.abchina.ibank.uip.eloan.apply.ContractDto;
import com.abchina.ibank.uip.eloan.apply.InvoiceDto;
import com.abchina.ibank.uip.eloan.apply.LoanApplyInfoDto;
import com.abchina.ibank.uip.eloan.apply.TradeContDto;
import com.abchina.ibank.uip.eloan.init.EntBaseInfo;
import com.abchina.ibank.uip.eloan.init.EntProductInfo;
import com.abchina.ibank.uip.eloan.init.EntSpecialInfo;
import com.abchina.ibank.uip.eloan.init.InitReqDomain;
import com.abchina.ibank.uip.eloan.search.AdminNotifyDomain;
import com.alibaba.fastjson.JSON;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.finance.dvas.common.constant.abc.AbcInitEnterpriseEnum;
import com.xforceplus.finance.dvas.common.constant.abc.AbcInitEnterpriseResultEnum;
import com.xforceplus.finance.dvas.common.constant.abc.AbcLoanApplyCodeEnum;
import com.xforceplus.finance.dvas.common.dto.abc.AdminttanceQueryRequest;
import com.xforceplus.finance.dvas.common.dto.abc.AdminttanceQueryResponse;
import com.xforceplus.finance.dvas.common.dto.abc.InitEnterpriseBaseInfoRequest;
import com.xforceplus.finance.dvas.common.dto.abc.InitEnterpriseBaseInfoResponse;
import com.xforceplus.finance.dvas.common.dto.abc.LengingNotify;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyBillDto;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyContractDto;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyInvoiceDto;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyNotifyDTO;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyRequest;
import com.xforceplus.finance.dvas.common.dto.abc.LoanApplyTradeContDto;
import com.xforceplus.finance.dvas.common.dto.abc.RepayNotifyDTO;
import com.xforceplus.finance.dvas.common.entity.abc.AbcInitEnterprise;
import com.xforceplus.finance.dvas.common.entity.abc.AbcInitEnterpriseInfo;
import com.xforceplus.finance.dvas.common.entity.abc.AbcLoanApplyLenging;
import com.xforceplus.finance.dvas.common.entity.abc.AbcLoanApplyRepay;
import com.xforceplus.finance.dvas.common.entity.abc.AbcLoanApplyResult;
import com.xforceplus.finance.dvas.common.enums.Message;
import com.xforceplus.finance.dvas.common.exception.DvasCommonServiceException;
import com.xforceplus.finance.dvas.common.repository.abc.AbcInitEnterpriseInfoMapper;
import com.xforceplus.finance.dvas.common.repository.abc.AbcInitEnterpriseMapper;
import com.xforceplus.finance.dvas.common.repository.abc.AbcLoanApplyLengingMapper;
import com.xforceplus.finance.dvas.common.repository.abc.AbcLoanApplyRepayMapper;
import com.xforceplus.finance.dvas.common.repository.abc.AbcLoanApplyResultMapper;
import com.xforceplus.finance.dvas.common.service.OssUtils;
import com.xforceplus.finance.dvas.common.service.abc.ABCConfig;
import com.xforceplus.finance.dvas.common.service.abc.ABCService;
import com.xforceplus.finance.dvas.common.utils.ThreadPoolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="abcService")
public class ABCServiceImpl
implements ABCService {
    private static final Logger log = LoggerFactory.getLogger(ABCServiceImpl.class);
    @Autowired
    private ABCConfig abcConfig;
    @Autowired
    private OssUtils ossUtils;
    @Autowired
    private AbcInitEnterpriseMapper abcInitEnterpriseMapper;
    @Autowired
    private AbcInitEnterpriseInfoMapper abcInitEnterpriseInfoMapper;
    @Autowired
    private AbcLoanApplyResultMapper abcLoanApplyResultMapper;
    @Autowired
    private AbcLoanApplyLengingMapper loanApplyLengingMapper;
    @Autowired
    private AbcLoanApplyRepayMapper abcLoanApplyRepayMapper;
    @Value(value="${abc.sysCode}")
    private String sysCode;
    @Value(value="${abc.productId}")
    private String productId;
    @Value(value="${abc.busiGroupCode}")
    private String busiGroupCode;
    private String apiName_initEnterprise = "EL_INIT_YL";
    private String apiName_adminttanceSearch = "EL_SEAINIT_YL";
    private String apiName_loanApply = "EL_APPLY_YL";
    @Value(value="${abc.mock.mockEnable}")
    private Boolean mockEnable;
    @Value(value="${abc.mock.mockInitEnterpriseURL}")
    private String mockInitEnterpriseURL;
    @Value(value="${abc.mock.mockLoanApplyURL}")
    private String mockLoanApplyURL;
    @Value(value="${daas.baseUrl}")
    private String daasBaseUrl;
    @Value(value="${daas.approve}")
    private String approve;
    @Value(value="${daas.fileToAbc}")
    private String fileToAbc;
    @Value(value="${daas.paySuccess}")
    private String paySuccess;
    @Value(value="${daas.repayment}")
    private String repayment;
    @Value(value="${daasPool.baseUrl}")
    private String daasPoolBaseURL;
    @Value(value="${daasPool.record}")
    private String recordURL;
    private String abcUrl = "https://open.test.abchina.com.cn/ibank-webservice-uip-dmz/uip/demo/getInfo";

    public InitEnterpriseBaseInfoResponse initEnterprise(InitEnterpriseBaseInfoRequest enterpriseBaseInfoDTO) {
        InitReqDomain initReqDomain = this.getInitReqDomain();
        EntBaseInfo entBaseInfo = this.getEntBaseInfo(enterpriseBaseInfoDTO);
        EntProductInfo entProductInfo = this.getEntProductInfo();
        initReqDomain.setEntBaseInfo(entBaseInfo);
        initReqDomain.setEntProductInfo(entProductInfo);
        Map<Object, Object> resultMap = null;
        String code = null;
        try {
            resultMap = this.mockEnable != false ? ABCServiceImpl.mockInvokeABC(this.mockInitEnterpriseURL) : this.invokeABC(this.apiName_initEnterprise, initReqDomain);
            resultMap = (Map<Object, Object>)JSON.parseObject((String)JSON.toJSONString((Object)resultMap.get("data")), resultMap.getClass());
            code = (String)resultMap.get("code");
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6c42\u519c\u884c\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)ex));
            this.notifyPool("ABC_INIT", "ABC", "YUNLI", JSON.toJSONString((Object)enterpriseBaseInfoDTO), resultMap);
            throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_SEND_FAILD.getCode(), JSON.toJSONString((Object)resultMap));
        }
        InitEnterpriseBaseInfoResponse initEnterpriseBaseInfoResponse = new InitEnterpriseBaseInfoResponse();
        AbcInitEnterprise abcInitEnterprise = new AbcInitEnterprise();
        if (!StringUtils.isNotEmpty((String)code) || !code.equalsIgnoreCase(AbcInitEnterpriseResultEnum.INIT_SUCCESS.getCode())) {
            initEnterpriseBaseInfoResponse.setMsg((String)resultMap.get("errorMessage"));
            initEnterpriseBaseInfoResponse.setCode((String)resultMap.get("errorCode"));
            abcInitEnterprise.setStatus(AbcInitEnterpriseEnum.SEND_FAIL.getStatus());
            log.warn("\u519c\u884c\u5ba2\u6237\u51c6\u5165\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)abcInitEnterprise));
            this.notifyPool("ABC_INIT", "ABC", "YUNLI", JSON.toJSONString((Object)enterpriseBaseInfoDTO), (Map<String, String>)resultMap);
            throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_FAILD.getCode(), JSON.toJSONString((Object)resultMap));
        }
        initEnterpriseBaseInfoResponse.setBusinessNo((String)resultMap.get("businessNo"));
        initEnterpriseBaseInfoResponse.setSrcId((String)resultMap.get("srcId"));
        initEnterpriseBaseInfoResponse.setCode((String)resultMap.get("code"));
        initEnterpriseBaseInfoResponse.setMsg((String)resultMap.get("msg"));
        abcInitEnterprise.setStatus(AbcInitEnterpriseEnum.SEND_SUCCESS.getStatus());
        abcInitEnterprise.setTaxNum(enterpriseBaseInfoDTO.getOrgCode());
        abcInitEnterprise.setCenterTaxNum(enterpriseBaseInfoDTO.getCoreOrgCode());
        abcInitEnterprise.setProductId(initReqDomain.getProductId());
        abcInitEnterprise.setBusiGroupCode(initReqDomain.getBusiGroupCode());
        abcInitEnterprise.setBusinessNo(initEnterpriseBaseInfoResponse.getBusinessNo());
        this.abcInitEnterpriseMapper.insert((Object)abcInitEnterprise);
        return initEnterpriseBaseInfoResponse;
    }

    private Map<String, String> invokeABC(String apiName, Object initReqDomain) {
        log.info("apiName:{},request->{}", (Object)apiName, initReqDomain);
        this.downloadABCAddress();
        ABCApi.init((String)this.abcConfig.getKey(), (String)this.abcConfig.getAddress());
        String response = ABCApi.send((String)this.abcConfig.getAbcUrl(), (String)apiName, (Object[])new Object[]{initReqDomain});
        log.info("apiName->{} , response->{}", (Object)apiName, (Object)response);
        Map resultMap = Maps.newHashMap();
        resultMap = (Map)JSON.parseObject((String)response, resultMap.getClass());
        return resultMap;
    }

    public static Map<String, String> mockInvokeABC(String requestURL) {
        log.info("mockInvokeABC requestURL{}", (Object)requestURL);
        String response = HttpUtil.get((String)requestURL);
        log.info("mockInvokeABC response->{}", (Object)response);
        Map resultMap = Maps.newHashMap();
        resultMap = (Map)JSON.parseObject((String)response, resultMap.getClass());
        return resultMap;
    }

    private void downloadABCAddress() {
        String devFileName = this.abcConfig.getAddress();
        String localFileFath = System.getProperty("user.dir") + File.separator + devFileName;
        if (FileUtil.exist((String)localFileFath)) {
            return;
        }
        String ossFilePath = this.abcConfig.getOssPath() + devFileName;
        log.info("downloadABCAddress ossFilePath:{}->", (Object)ossFilePath);
        this.ossUtils.downloadOssFileToLocal(ossFilePath, localFileFath);
    }

    public AdminttanceQueryResponse adminttanceQuery(AdminttanceQueryRequest adminttacneQueryRequest) {
        AbcInitEnterprise abcInitEnterprise = this.getAbcInitEnterprise(adminttacneQueryRequest.getOrgCode(), adminttacneQueryRequest.getCoreOrgCode(), true);
        if (abcInitEnterprise.getStatus().intValue() == AbcInitEnterpriseEnum.APPLY_SUCCESS.getStatus().intValue()) {
            log.info("\u5df2\u7ecf\u51c6\u5165\u6210\u529f,abcInitEnterprise->{}", (Object)abcInitEnterprise);
            AdminttanceQueryResponse adminttanceQueryResponse = new AdminttanceQueryResponse(AbcInitEnterpriseResultEnum.INIT_SUCCESS.getCode(), AbcInitEnterpriseResultEnum.INIT_SUCCESS.getDesc());
            AbcInitEnterpriseInfo dbAbcInitEnterpriseInfo = this.abcInitEnterpriseInfoMapper.queryByCenterTaxNumAndTaxNum(abcInitEnterprise.getTaxNum(), this.productId);
            adminttanceQueryResponse.setExecRate(dbAbcInitEnterpriseInfo.getExecRate());
            adminttanceQueryResponse.setRecvAcc(dbAbcInitEnterpriseInfo.getRecvAcc());
            adminttanceQueryResponse.setRecvName(dbAbcInitEnterpriseInfo.getRecvName());
            return adminttanceQueryResponse;
        }
        AdminNotifyDomain adminNotifyDomain = this.buildAdminttanceSearch(adminttacneQueryRequest, abcInitEnterprise);
        return this.doAdminttance(adminttacneQueryRequest, abcInitEnterprise, adminNotifyDomain);
    }

    public AbcInitEnterprise getAbcInitEnterprise(String orgCode, String coreOrgCode, Boolean isDavs) {
        log.info("orgCode->{}", (Object)orgCode);
        log.info("coreOrgCode->{}", (Object)coreOrgCode);
        AbcInitEnterprise abcInitEnterprise = null;
        abcInitEnterprise = isDavs != false ? this.abcInitEnterpriseMapper.queryBusinessNoByCenterTaxNumAndTaxNum(orgCode, coreOrgCode) : this.abcInitEnterpriseMapper.queryLikeBusinessNoByCenterTaxNumAndTaxNum(orgCode, coreOrgCode);
        if (abcInitEnterprise == null) {
            log.info("abcInitEnterprise is null");
            throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_DATA_NO_EXIST);
        }
        return abcInitEnterprise;
    }

    private AdminttanceQueryResponse doAdminttance(AdminttanceQueryRequest adminttacneQueryRequest, AbcInitEnterprise abcInitEnterprise, AdminNotifyDomain adminNotifyDomain) {
        Map resultMap = this.invokeABC(this.apiName_adminttanceSearch, adminNotifyDomain);
        if (resultMap == null || resultMap.get("data") == null) {
            this.notifyPool("ABC_init_query", "ABC", "YUNLI", JSON.toJSONString((Object)adminttacneQueryRequest), Maps.newHashMap());
            throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_EXCEPTION);
        }
        resultMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)resultMap.get("data")), resultMap.getClass());
        return this.doAdminttanceQueryResponse(abcInitEnterprise, adminNotifyDomain, resultMap);
    }

    public Boolean doAdminttanceQuery(Map<String, String> resultMap) {
        AbcInitEnterprise abcInitEnterprise = this.getAbcInitEnterprise(resultMap.get("orgCode"), resultMap.get("coreOrgCode"), false);
        AdminNotifyDomain adminNotifyDomain = new AdminNotifyDomain();
        adminNotifyDomain.setProductId(resultMap.get("productId"));
        adminNotifyDomain.setOrgCode(resultMap.get("orgCode"));
        adminNotifyDomain.setBusiGroupCode(resultMap.get("busiGroupCode"));
        adminNotifyDomain.setBusinessNo(resultMap.get("busiGroupCode"));
        AdminttanceQueryResponse adminttanceQueryResponse = this.doAdminttanceQueryResponse(abcInitEnterprise, adminNotifyDomain, resultMap);
        return adminttanceQueryResponse != null ? Boolean.TRUE : Boolean.FALSE;
    }

    private AdminttanceQueryResponse doAdminttanceQueryResponse(AbcInitEnterprise abcInitEnterprise, AdminNotifyDomain adminNotifyDomain, Map<String, String> resultMap) {
        String code = resultMap.get("code");
        String msg = resultMap.get("msg");
        if (StringUtils.isEmpty((String)code)) {
            this.notifyPool("ABC_init_query", "ABC", "YUNLI", JSON.toJSONString((Object)adminNotifyDomain), resultMap);
            throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_EXCEPTION);
        }
        if (StringUtils.isNotEmpty((String)code) && code.equalsIgnoreCase(AbcInitEnterpriseResultEnum.INIT_SUCCESS.getCode())) {
            AbcInitEnterpriseInfo abcInitEnterpriseInfo = new AbcInitEnterpriseInfo();
            abcInitEnterpriseInfo.setProductId(adminNotifyDomain.getProductId());
            abcInitEnterpriseInfo.setTaxNum(abcInitEnterprise.getTaxNum());
            abcInitEnterpriseInfo.setBusiGroupCode(adminNotifyDomain.getBusiGroupCode());
            abcInitEnterpriseInfo.setBusinessNo(adminNotifyDomain.getBusinessNo());
            abcInitEnterpriseInfo.setClientCode(resultMap.get("clientCode"));
            abcInitEnterpriseInfo.setSrcId(resultMap.get("srcId"));
            abcInitEnterpriseInfo.setCode(resultMap.get("code"));
            abcInitEnterpriseInfo.setMsg(resultMap.get("msg"));
            abcInitEnterpriseInfo.setStartDate(resultMap.get("startDate"));
            abcInitEnterpriseInfo.setEndDate(resultMap.get("endDate"));
            abcInitEnterpriseInfo.setGrade(resultMap.get("grade"));
            abcInitEnterpriseInfo.setLimitAmt(String.valueOf(resultMap.get("limitAmt")));
            abcInitEnterpriseInfo.setExecRate(String.valueOf(resultMap.get("execRate")));
            abcInitEnterpriseInfo.setFactFeeRate(String.valueOf(resultMap.get("factFeeRate")));
            abcInitEnterpriseInfo.setRecvName(resultMap.get("recvName"));
            abcInitEnterpriseInfo.setRecvAcc(resultMap.get("recvAcc"));
            AbcInitEnterpriseInfo dbAbcInitEnterpriseInfo = this.abcInitEnterpriseInfoMapper.queryByCenterTaxNumAndTaxNum(abcInitEnterpriseInfo.getTaxNum(), abcInitEnterpriseInfo.getProductId());
            if (dbAbcInitEnterpriseInfo != null) {
                abcInitEnterpriseInfo.setCreateTime(LocalDateTime.now());
                abcInitEnterpriseInfo.setRecordId(dbAbcInitEnterpriseInfo.getRecordId());
                this.abcInitEnterpriseInfoMapper.updateById((Object)abcInitEnterpriseInfo);
            } else {
                this.abcInitEnterpriseInfoMapper.insert((Object)abcInitEnterpriseInfo);
            }
            this.abcInitEnterpriseMapper.updateStatus(abcInitEnterprise.getRecordId(), AbcInitEnterpriseEnum.APPLY_SUCCESS.getStatus(), abcInitEnterprise.getStatus());
            AdminttanceQueryResponse adminttanceQueryResponse = new AdminttanceQueryResponse(AbcInitEnterpriseResultEnum.INIT_SUCCESS.getCode(), msg);
            adminttanceQueryResponse.setExecRate(abcInitEnterpriseInfo.getExecRate());
            adminttanceQueryResponse.setRecvAcc(abcInitEnterpriseInfo.getRecvAcc());
            adminttanceQueryResponse.setRecvName(abcInitEnterpriseInfo.getRecvName());
            return adminttanceQueryResponse;
        }
        if (code.equalsIgnoreCase(AbcInitEnterpriseResultEnum.INIT_ING.getCode())) {
            AdminttanceQueryResponse adminttanceQueryResponse = new AdminttanceQueryResponse(AbcInitEnterpriseResultEnum.INIT_ING.getCode(), msg);
            return adminttanceQueryResponse;
        }
        if (code.equalsIgnoreCase(AbcInitEnterpriseResultEnum.FROZEN.getCode())) {
            AdminttanceQueryResponse adminttanceQueryResponse = new AdminttanceQueryResponse(AbcInitEnterpriseResultEnum.FROZEN.getCode(), msg);
            return adminttanceQueryResponse;
        }
        this.notifyPool("ABC_init_query", "ABC", "YUNLI", JSON.toJSONString((Object)adminNotifyDomain), resultMap);
        throw new DvasCommonServiceException(Message.INIT_ENTERPRISE_EXCEPTION);
    }

    public Boolean loanApply(LoanApplyRequest loanApplyRequest) {
        AbcLoanApplyResult abcLoanApplyResult = this.abcLoanApplyResultMapper.queryByOutApplyNo(loanApplyRequest.getOutApplyNo());
        if (abcLoanApplyResult != null && abcLoanApplyResult.getCode() != null && abcLoanApplyResult.getCode().equalsIgnoreCase(AbcLoanApplyCodeEnum.LOAN_APPLY_SUCCESS.getCode())) {
            log.warn("\u5df2\u7ecf\u53d1\u8d77\u8fc7\u878d\u8d44\u7533\u8bf7\u3002\u65e0\u9700\u91cd\u65b0\u53d1\u8d77 outApplyNo:{}", (Object)loanApplyRequest.getOutApplyNo());
            return true;
        }
        LoanApplyInfoDto loanApplyInfoDto = this.buildLoanApplyInfoDto(loanApplyRequest);
        Map resultMap = null;
        String response = null;
        if (this.mockEnable.booleanValue()) {
            resultMap = ABCServiceImpl.mockInvokeABC(this.mockLoanApplyURL);
        } else {
            log.info("abcConfig.getKey():{}", (Object)this.abcConfig.getKey());
            this.downloadABCAddress();
            ABCApi.init((String)this.abcConfig.getKey(), (String)this.abcConfig.getAddress());
            response = ABCApi.send((String)this.abcConfig.getAbcUrl(), (String)this.apiName_loanApply, (Object[])new Object[]{loanApplyInfoDto});
            log.info("response->{}", (Object)response);
            resultMap = Maps.newHashMap();
            resultMap = (Map)JSON.parseObject((String)response, resultMap.getClass());
            resultMap = (Map)JSON.parseObject((String)JSON.toJSONString(resultMap.get("data")), resultMap.getClass());
        }
        if (resultMap == null || resultMap.size() == 0) {
            log.error("resultMap is null");
            this.notifyPool("ABC_LOAN_APPLY", "ABC", "YUNLI", JSON.toJSONString((Object)loanApplyRequest), resultMap);
            throw new DvasCommonServiceException(Message.ABC_LoanApply_EXCEPTION.getCode(), response);
        }
        String code = resultMap.get("code");
        if (StringUtils.isNotEmpty((String)code) && code.equalsIgnoreCase(AbcInitEnterpriseResultEnum.INIT_SUCCESS_1.getCode())) {
            AbcLoanApplyResult newAbbcLoanApplyResult = new AbcLoanApplyResult();
            newAbbcLoanApplyResult.setTaxNum(loanApplyRequest.getOrgCode());
            newAbbcLoanApplyResult.setBusinessNo(loanApplyInfoDto.getBusinessNo());
            newAbbcLoanApplyResult.setLoanApplyNo((String)resultMap.get("loanApplyNo"));
            newAbbcLoanApplyResult.setOutApplyNo((String)resultMap.get("outApplyNo"));
            newAbbcLoanApplyResult.setCreateTime(LocalDateTime.now());
            log.info("newAbbcLoanApplyResult->{}", (Object)JSON.toJSONString((Object)newAbbcLoanApplyResult));
            if (abcLoanApplyResult == null) {
                this.abcLoanApplyResultMapper.insert((Object)newAbbcLoanApplyResult);
            } else {
                this.abcLoanApplyResultMapper.updateByOutApplyNo(newAbbcLoanApplyResult);
            }
        } else {
            log.error("loanApply fail ");
            this.notifyPool("ABC_LOAN_APPLY", "ABC", "YUNLI", JSON.toJSONString((Object)loanApplyRequest), resultMap);
            throw new DvasCommonServiceException(Message.ABC_LoanApply_EXCEPTION.getCode(), response);
        }
        ThreadPoolUtils.getInstance().execute(() -> {
            log.info("\u878d\u8d44\u7533\u8bf7\uff0c\u5f02\u6b65\u8c03\u7528,loanApplyRequest:{}", (Object)JSON.toJSONString((Object)loanApplyRequest));
            String paramPath = "?billNo=" + ((LoanApplyBillDto)loanApplyRequest.getBillList().get(0)).getBillNo() + "&busiGroupCode=" + this.busiGroupCode + "&outApplyNo=" + loanApplyRequest.getOutApplyNo() + "&taxNum=" + loanApplyRequest.getOrgCode();
            this.notifyDvas(this.fileToAbc, paramPath);
        });
        return true;
    }

    public Boolean loanApplyNotify(LoanApplyNotifyDTO loanApplyNotifyDTO) {
        AbcLoanApplyResult abcLoanApplyResult = this.abcLoanApplyResultMapper.queryByLoanApplyNoAndOutApplyNo(loanApplyNotifyDTO.getLoanApplyNo(), loanApplyNotifyDTO.getOutApplyNo());
        if (abcLoanApplyResult == null) {
            log.error("loanApplyNotify abcLoanApplyResult is null ,loanApplyNotifyDTO:{}", (Object)loanApplyNotifyDTO);
            return false;
        }
        abcLoanApplyResult.setCode(loanApplyNotifyDTO.getCode());
        abcLoanApplyResult.setMsg(loanApplyNotifyDTO.getMsg());
        abcLoanApplyResult.setAppvDate(loanApplyNotifyDTO.getAppvDate());
        abcLoanApplyResult.setContContent(loanApplyNotifyDTO.getContContent());
        abcLoanApplyResult.setRecvName(loanApplyNotifyDTO.getRecvName());
        abcLoanApplyResult.setRecvAcc(loanApplyNotifyDTO.getRecvAcc());
        int updateSize = this.abcLoanApplyResultMapper.updateById((Object)abcLoanApplyResult);
        if (updateSize != 1) {
            log.error("\u878d\u8d44\u7533\u8bf7\u5ba1\u6279\u7ed3\u679c\u53cd\u9988\u66f4\u65b0\u5931\u8d25:{}", (Object)loanApplyNotifyDTO);
        }
        String paramPath = "?aproveTime=" + abcLoanApplyResult.getAppvDate() + "&message=" + abcLoanApplyResult.getMsg() + "&payApplyNo=" + abcLoanApplyResult.getOutApplyNo() + "&status=" + abcLoanApplyResult.getCode();
        this.notifyDvas(this.approve, paramPath);
        return true;
    }

    public void notifyDvas(String suffixPath, String paramPath) {
        String requestUrl = this.daasBaseUrl + suffixPath + paramPath;
        log.info("notifyDavs request url:->{}", (Object)requestUrl);
        String response = HttpUtil.get((String)requestUrl);
        log.info("notifyDavs response:->{}", (Object)response);
    }

    public void notifyPool(String interfaceConfigEnum, String destinationEnum, String originEnum, String paramMap, Map<String, String> resultMap) {
        ThreadPoolUtils.getInstance().execute(() -> {
            String requestUrl = this.daasPoolBaseURL + this.recordURL;
            log.info("notifyPool request url:->{}", (Object)requestUrl);
            log.info("notifyPool request interfaceConfigEnum:->{}", (Object)interfaceConfigEnum);
            log.info("notifyPool request destinationEnum:->{}", (Object)destinationEnum);
            log.info("notifyPool request paramMap:->{}", (Object)paramMap);
            log.info("notifyPool request resultMap:->{}", (Object)resultMap);
            HashMap requestMap = Maps.newHashMap();
            requestMap.put("interfaceConfigEnum", interfaceConfigEnum);
            requestMap.put("destinationEnum", destinationEnum);
            requestMap.put("originEnum", originEnum);
            requestMap.put("requestMap", paramMap);
            requestMap.put("resultMap", resultMap);
            String response = HttpUtil.post((String)requestUrl, (Map)requestMap);
            log.info("notifyPool response:->{}", (Object)response);
        });
    }

    public Boolean lengingNotify(LengingNotify lengingNotify) {
        AbcLoanApplyLenging abcLoanApplyLenging = this.loanApplyLengingMapper.queryByLoanApplyNoAndOutApplyNo(lengingNotify.getLoanApplyNo(), lengingNotify.getOutApplyNo());
        if (abcLoanApplyLenging != null) {
            log.warn("\u5df2\u7ecf\u63a5\u6536\u8fc7\u653e\u6b3e\u901a\u77e5,abcLoanApplyLenging:{}", (Object)abcLoanApplyLenging);
            log.warn("\u6700\u65b0\u7684\u653e\u901a\u77e5\u5185\u5bb9\u4e3a,lengingNotify:{}", (Object)lengingNotify);
            return false;
        }
        AbcLoanApplyLenging loanApplyLenging = new AbcLoanApplyLenging();
        loanApplyLenging.setProductId(lengingNotify.getProductId());
        loanApplyLenging.setBusiGroupCode(lengingNotify.getBusiGroupCode());
        loanApplyLenging.setLoanApplyNo(lengingNotify.getLoanApplyNo());
        loanApplyLenging.setOutApplyNo(lengingNotify.getOutApplyNo());
        loanApplyLenging.setCode(lengingNotify.getCode());
        loanApplyLenging.setAmount(lengingNotify.getAmount());
        loanApplyLenging.setStartDate(lengingNotify.getStartDate());
        loanApplyLenging.setLoanEndDate(lengingNotify.getLoanEndDate());
        loanApplyLenging.setRepayWay(lengingNotify.getRepayWay());
        loanApplyLenging.setRecvAcc(lengingNotify.getRecvAcc());
        loanApplyLenging.setRepayAame(lengingNotify.getRepayName());
        loanApplyLenging.setRecvAcc(lengingNotify.getRecvAcc());
        loanApplyLenging.setRepayBankName(lengingNotify.getRepayBankName());
        loanApplyLenging.setRepayAbisno(lengingNotify.getRepayABISNo());
        loanApplyLenging.setExecRate(lengingNotify.getExecRate());
        loanApplyLenging.setInterest(lengingNotify.getInterest());
        loanApplyLenging.setFactFeeRate(lengingNotify.getFactFeeRate());
        loanApplyLenging.setFactFee(lengingNotify.getFactFee());
        loanApplyLenging.setPlatformFee(lengingNotify.getPlatformFee());
        loanApplyLenging.setPlatformRate(lengingNotify.getPlatformRate());
        loanApplyLenging.setPlatformFee(lengingNotify.getPlatformFee());
        loanApplyLenging.setMsg(lengingNotify.getMsg());
        loanApplyLenging.setContno(lengingNotify.getContno());
        loanApplyLenging.setSzarSeqNum(lengingNotify.getSzArSeqNum());
        loanApplyLenging.setJrnNo(lengingNotify.getJrnNo());
        loanApplyLenging.setVchno(lengingNotify.getVchno());
        loanApplyLenging.setRelatedCredence(lengingNotify.getRelatedCredence());
        loanApplyLenging.setCreateTime(LocalDateTime.now());
        this.loanApplyLengingMapper.insert((Object)loanApplyLenging);
        String paramPath = "?endDate=" + loanApplyLenging.getLoanEndDate() + "&fee=" + loanApplyLenging.getFactFee() + "&payAmount=" + loanApplyLenging.getAmount() + "&payApplyNo=" + loanApplyLenging.getOutApplyNo() + "&payResult=" + loanApplyLenging.getCode() + "&startDate=" + loanApplyLenging.getStartDate() + "&execRate=" + loanApplyLenging.getExecRate() + "&interest=" + loanApplyLenging.getInterest();
        this.notifyDvas(this.paySuccess, paramPath);
        return true;
    }

    public Boolean repayNotifyDTO(RepayNotifyDTO repayNotifyDTO) {
        AbcLoanApplyRepay loanApplyRepay = this.abcLoanApplyRepayMapper.queryByLoanApplyNoAndOutApplyNo(repayNotifyDTO.getLoanApplyNo(), repayNotifyDTO.getOutApplyNo());
        if (loanApplyRepay != null) {
            log.warn("\u5df2\u7ecf\u63a5\u6536\u8fc7\u8fd8\u6b3e\u7ed3\u679c\u53cd\u9988,abcLoanApplyRepay:{}", (Object)loanApplyRepay);
            log.warn("\u6700\u65b0\u7684\u8fd8\u6b3e\u7ed3\u679c\u5185\u5bb9\u4e3a,repayNotifyDTO:{}", (Object)repayNotifyDTO);
            return false;
        }
        AbcLoanApplyRepay abcLoanApplyRepay = new AbcLoanApplyRepay();
        abcLoanApplyRepay.setProductId(repayNotifyDTO.getProductId());
        abcLoanApplyRepay.setBusiGroupCode(repayNotifyDTO.getBusiGroupCode());
        abcLoanApplyRepay.setBusinessNo(repayNotifyDTO.getBusinessNo());
        abcLoanApplyRepay.setOutApplyNo(repayNotifyDTO.getOutApplyNo());
        abcLoanApplyRepay.setLoanApplyNo(repayNotifyDTO.getLoanApplyNo());
        abcLoanApplyRepay.setPaidAmount(repayNotifyDTO.getPaidAmt());
        abcLoanApplyRepay.setRepayDate(repayNotifyDTO.getRepayDate());
        abcLoanApplyRepay.setDueDate(repayNotifyDTO.getDueDate());
        abcLoanApplyRepay.setRemainAmt(repayNotifyDTO.getRemainAmt());
        abcLoanApplyRepay.setAttribute1(repayNotifyDTO.getAttribute1());
        abcLoanApplyRepay.setCreateTime(LocalDateTime.now());
        this.abcLoanApplyRepayMapper.insert((Object)abcLoanApplyRepay);
        String paramPath = "?payApplyNo=" + abcLoanApplyRepay.getOutApplyNo() + "&repaymentDate=" + abcLoanApplyRepay.getRepayDate() + "&repaymentStatus=" + abcLoanApplyRepay.getAttribute1();
        this.notifyDvas(this.repayment, paramPath);
        return true;
    }

    void repayNotify() {
    }

    InitReqDomain getInitReqDomain() {
        InitReqDomain initReqDto = new InitReqDomain();
        initReqDto.setProductId(this.productId);
        initReqDto.setSysCode(this.sysCode);
        initReqDto.setBusiGroupCode(this.busiGroupCode);
        return initReqDto;
    }

    EntBaseInfo getEntBaseInfo(InitEnterpriseBaseInfoRequest enterpriseBaseInfoDTO) {
        EntBaseInfo entBaseInfo = new EntBaseInfo();
        entBaseInfo.setEntChineseFullName(enterpriseBaseInfoDTO.getCompanyName());
        entBaseInfo.setEntChineseName(enterpriseBaseInfoDTO.getCompanyName());
        entBaseInfo.setOrgCode(enterpriseBaseInfoDTO.getOrgCode());
        entBaseInfo.setRegisterCur(enterpriseBaseInfoDTO.getRegisterCur());
        entBaseInfo.setRegisterCap(enterpriseBaseInfoDTO.getRegisterCap());
        entBaseInfo.setBusiLicense(enterpriseBaseInfoDTO.getBusiLicense());
        entBaseInfo.setRegisterDate(enterpriseBaseInfoDTO.getRegisterDate());
        entBaseInfo.setRegisterAddr(enterpriseBaseInfoDTO.getRegisterAddr());
        entBaseInfo.setCorpName(enterpriseBaseInfoDTO.getCorpName());
        entBaseInfo.setCorpCertType(enterpriseBaseInfoDTO.getCorpCertType());
        entBaseInfo.setCorpCertNo(enterpriseBaseInfoDTO.getCorpCertNo());
        entBaseInfo.setCorpCellNo(enterpriseBaseInfoDTO.getCorpCellNo());
        entBaseInfo.setOwnName(enterpriseBaseInfoDTO.getOwnName());
        entBaseInfo.setOwnCertType(enterpriseBaseInfoDTO.getOwnCertType());
        entBaseInfo.setOwnCertNo(enterpriseBaseInfoDTO.getOwnCertNo());
        entBaseInfo.setOwnCellNo(enterpriseBaseInfoDTO.getOwnCellNo());
        entBaseInfo.setCoreOrgCode(enterpriseBaseInfoDTO.getCoreOrgCode());
        entBaseInfo.setCoreEntName(enterpriseBaseInfoDTO.getCoreEntName());
        entBaseInfo.setRvrName(enterpriseBaseInfoDTO.getRvrName());
        entBaseInfo.setRvrCertType(enterpriseBaseInfoDTO.getRvrCertType());
        entBaseInfo.setRvrCertNo(enterpriseBaseInfoDTO.getRvrCertNo());
        entBaseInfo.setRvrCellNo(enterpriseBaseInfoDTO.getRvrCellNo());
        entBaseInfo.setContactAddr(enterpriseBaseInfoDTO.getContactAddr());
        entBaseInfo.setEntCellNo(enterpriseBaseInfoDTO.getEntCellNo());
        entBaseInfo.setEntPostCode(enterpriseBaseInfoDTO.getEntPostCode());
        entBaseInfo.setEntFaxNo(enterpriseBaseInfoDTO.getEntFaxNo());
        entBaseInfo.setEntEmail(enterpriseBaseInfoDTO.getEntEmail());
        ArrayList entSpecialInfoList = Lists.newArrayList();
        entSpecialInfoList.add(this.getEntSpecialInfo());
        entBaseInfo.setSpcList((List)entSpecialInfoList);
        return entBaseInfo;
    }

    AdminNotifyDomain getAdminttanceNotify() {
        AdminNotifyDomain adminNotifyDomain = this.baseAdminNotifyDomain();
        adminNotifyDomain.setSrcId("");
        adminNotifyDomain.setEntName("");
        adminNotifyDomain.setOrgCode("");
        adminNotifyDomain.setCode("");
        adminNotifyDomain.setMsg("");
        adminNotifyDomain.setStartDate("");
        adminNotifyDomain.setEndDate("");
        adminNotifyDomain.setGrade("");
        adminNotifyDomain.setLimitAmt(new BigDecimal(""));
        adminNotifyDomain.setExecRate(new BigDecimal(""));
        adminNotifyDomain.setFactFeeRate(new BigDecimal(""));
        adminNotifyDomain.setRecvName("");
        adminNotifyDomain.setRecvAcc("");
        adminNotifyDomain.setBusinessNo("");
        return adminNotifyDomain;
    }

    AdminNotifyDomain buildAdminttanceSearch(AdminttanceQueryRequest adminttacneQueryRequest, AbcInitEnterprise abcInitEnterprise) {
        AdminNotifyDomain adminNotifyDomain = new AdminNotifyDomain();
        adminNotifyDomain.setProductId(this.productId);
        adminNotifyDomain.setSysCode(this.sysCode);
        adminNotifyDomain.setBusiGroupCode(this.busiGroupCode);
        adminNotifyDomain.setCoreOrgCode(adminttacneQueryRequest.getCoreOrgCode());
        adminNotifyDomain.setOrgCode(adminttacneQueryRequest.getOrgCode());
        adminNotifyDomain.setBusinessNo(abcInitEnterprise.getBusinessNo());
        return adminNotifyDomain;
    }

    LoanApplyInfoDto buildLoanApplyInfoDto(LoanApplyRequest loanApplyRequest) {
        AbcInitEnterpriseInfo dbAbcInitEnterpriseInfo = this.abcInitEnterpriseInfoMapper.queryByCenterTaxNumAndTaxNum(loanApplyRequest.getOrgCode(), this.productId);
        if (dbAbcInitEnterpriseInfo == null) {
            log.warn("dbAbcInitEnterpriseInfo is null  ");
            throw new DvasCommonServiceException(Message.LOAN_APP_ENTERPRISE_NOT_EXISTS_EXCEPTION);
        }
        if (!dbAbcInitEnterpriseInfo.getCode().equalsIgnoreCase(AbcInitEnterpriseResultEnum.INIT_SUCCESS.getCode())) {
            log.warn("dbAbcInitEnterpriseInfo info {}  ", (Object)dbAbcInitEnterpriseInfo);
            throw new DvasCommonServiceException(Message.LOAN_APP_ENTERPRISE_NOT_STATUS_EXCEPTION);
        }
        LoanApplyInfoDto loanApplyInfoDto = new LoanApplyInfoDto();
        loanApplyInfoDto.setProductId(this.productId);
        loanApplyInfoDto.setSysCode(this.sysCode);
        loanApplyInfoDto.setBusiGroupCode(this.busiGroupCode);
        loanApplyInfoDto.setBusinessNo(loanApplyRequest.getBusinessNo());
        loanApplyInfoDto.setClientCode(dbAbcInitEnterpriseInfo.getClientCode());
        loanApplyInfoDto.setOutApplyNo(loanApplyRequest.getOutApplyNo());
        loanApplyInfoDto.setEntName(loanApplyRequest.getEntName());
        loanApplyInfoDto.setCurrType(loanApplyRequest.getCurrType());
        loanApplyInfoDto.setExpectLoanAmt(loanApplyRequest.getExpectLoanAmt());
        loanApplyInfoDto.setCoreOrgCode(loanApplyRequest.getCoreOrgCode());
        loanApplyInfoDto.setCoreEntName(loanApplyRequest.getCoreEntName());
        loanApplyInfoDto.setContSignType(loanApplyRequest.getContSignType());
        loanApplyInfoDto.setLoanRate(loanApplyRequest.getLoanRate());
        loanApplyInfoDto.setFactRate(new BigDecimal("0.00"));
        loanApplyInfoDto.setApplyStartDate(loanApplyRequest.getApplyStartDate());
        loanApplyInfoDto.setApplyEndDate(loanApplyRequest.getApplyEndDate());
        long loanDays = DateUtil.between((Date)DateUtil.parse((CharSequence)loanApplyInfoDto.getApplyStartDate(), (String)"yyyyMMdd"), (Date)DateUtil.parse((CharSequence)loanApplyInfoDto.getApplyEndDate(), (String)"yyyyMMdd"), (DateUnit)DateUnit.DAY);
        BigDecimal loanFee = loanApplyInfoDto.getExpectLoanAmt().multiply(loanApplyInfoDto.getLoanRate()).multiply(new BigDecimal(loanDays)).divide(new BigDecimal("36000"), 2, 4);
        loanApplyInfoDto.setLoanInterest(loanFee);
        loanApplyInfoDto.setFactFee(loanApplyRequest.getFactFee());
        loanApplyInfoDto.setPlatformRate(loanApplyRequest.getPlatformRate());
        loanApplyInfoDto.setPlatformFee(loanApplyRequest.getPlatformFee());
        if (loanApplyRequest.getPersonalCreditFileUrl() == null) {
            loanApplyInfoDto.setPersonalCreditLA("null");
        } else {
            log.info("personalCreditFileUrl:{}", (Object)loanApplyRequest.getPersonalCreditFileUrl());
            loanApplyInfoDto.setPersonalCreditLA(this.getOSSFileByFileUrl(loanApplyRequest.getPersonalCreditFileUrl()));
        }
        log.info("enterpriseCreditLA:{}", (Object)loanApplyRequest.getEnterpriseCreditFileUrl());
        loanApplyInfoDto.setEnterpriseCreditLA(this.getOSSFileByFileUrl(loanApplyRequest.getEnterpriseCreditFileUrl()));
        ArrayList list = new ArrayList();
        loanApplyInfoDto.setEntSpecialInfos(list);
        loanApplyInfoDto.setBillList(this.getBillList(loanApplyRequest));
        loanApplyInfoDto.setContractDto(this.getContractDto(loanApplyRequest, dbAbcInitEnterpriseInfo));
        return loanApplyInfoDto;
    }

    public static String getImgStr(String imgFile) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64(data));
    }

    public String getOSSFileByFileId(Long fileId) {
        InputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = this.ossUtils.downloadInputStream(fileId);
            data = new byte[inputStream.available()];
            inputStream.read(data);
            inputStream.close();
        }
        catch (IOException e) {
            log.error("getOSSFileByFileId error:{}", (Throwable)e);
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    public String getOSSFileByFileUrl(String fileUrl) {
        if (fileUrl == null) {
            throw new IllegalArgumentException("fileUrl is null");
        }
        File file = new File("test1");
        Long fileSize = HttpUtil.downloadFile((String)fileUrl, (File)file);
        if (fileSize <= 0L) {
            log.error("fileSize is :{} url:{}  name:{}", new Object[]{fileSize, fileUrl, "test1"});
        }
        byte[] data = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            data = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(data);
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            log.error("getOSSFileByFileId error:{}", (Throwable)e);
        }
        file.delete();
        return new String(Base64.encodeBase64((byte[])data));
    }

    List<BillDto> getBillList(LoanApplyRequest loanApplyRequest) {
        ArrayList<BillDto> flowBillList = new ArrayList<BillDto>();
        loanApplyRequest.getBillList().forEach(dto -> {
            BillDto billDto = this.buildBillDto(loanApplyRequest, (LoanApplyBillDto)dto);
            flowBillList.add(billDto);
        });
        return flowBillList;
    }

    private BillDto buildBillDto(LoanApplyRequest loanApplyRequest, LoanApplyBillDto dto) {
        BillDto billDto = new BillDto();
        billDto.setBillNo(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        billDto.setBillType(dto.getBillType());
        billDto.setBillOpenEnt(loanApplyRequest.getCoreEntName());
        billDto.setParentBillEnt(loanApplyRequest.getCoreEntName());
        billDto.setBillAmt(dto.getBillAmt());
        billDto.setBillOpenDate(dto.getBillOpenDate());
        billDto.setBillEndDate(dto.getBillEndDate());
        billDto.setEntSpecialInfos(new ArrayList());
        billDto.setTradeContDtoList(this.getTradeContList(dto.getTradeContList()));
        billDto.setInvoiceList(this.getInvoiceList(dto.getInvoiceList()));
        return billDto;
    }

    List<TradeContDto> getTradeContList(List<LoanApplyTradeContDto> tradeContList) {
        ArrayList<TradeContDto> tradeContDtoList = new ArrayList<TradeContDto>();
        tradeContList.forEach(loanApplyTradeContDto -> {
            TradeContDto tradeContDto = new TradeContDto();
            tradeContDto.setTradeContNo(loanApplyTradeContDto.getTradeContNo());
            tradeContDto.setTradeContAmt(loanApplyTradeContDto.getTradeContAmt());
            tradeContDto.setTradeContSignDate(loanApplyTradeContDto.getTradeContSignDate());
            tradeContDto.setTradeContEndDate(loanApplyTradeContDto.getTradeContEndDate());
            tradeContDto.setTradeContPurchaserName(loanApplyTradeContDto.getTradeContPurchaserName());
            tradeContDto.setTradeContSalerName(loanApplyTradeContDto.getTradeContSalerName());
            ArrayList list = new ArrayList();
            tradeContDto.setSpecialInfos(list);
            tradeContDtoList.add(tradeContDto);
        });
        return tradeContDtoList;
    }

    List<InvoiceDto> getInvoiceList(List<LoanApplyInvoiceDto> loanApplyInvoiceDtoList) {
        ArrayList<InvoiceDto> invoiceDtoList = new ArrayList<InvoiceDto>();
        loanApplyInvoiceDtoList.forEach(loanApplyInvoiceDto -> {
            InvoiceDto invoiceDto = new InvoiceDto();
            invoiceDto.setInvoId(loanApplyInvoiceDto.getInvoId());
            invoiceDto.setInvoNo(loanApplyInvoiceDto.getInvoNo());
            invoiceDto.setInvoOpenDate(loanApplyInvoiceDto.getInvoOpenDate());
            invoiceDto.setInvoNoTaxAmt(loanApplyInvoiceDto.getInvoNoTaxAmt());
            invoiceDto.setInvoTaxAmt(loanApplyInvoiceDto.getInvoTaxAmt());
            invoiceDto.setInvoPurchaserName(loanApplyInvoiceDto.getInvoPurchaserName());
            invoiceDto.setInvoSalesName(loanApplyInvoiceDto.getInvoSalesName());
            invoiceDto.setCheckCode(loanApplyInvoiceDto.getCheckCode());
            ArrayList list = new ArrayList();
            invoiceDto.setSpecialInfos(list);
            invoiceDtoList.add(invoiceDto);
        });
        return invoiceDtoList;
    }

    ContractDto getContractDto(LoanApplyRequest loanApplyRequest, AbcInitEnterpriseInfo dbAbcInitEnterpriseInfo) {
        LoanApplyContractDto loanApplyContractDto = loanApplyRequest.getLoanApplyContractDto();
        ContractDto contractDto = new ContractDto();
        contractDto.setLoanContNo(loanApplyContractDto.getLoanContNo());
        if (StringUtils.isEmpty((String)loanApplyContractDto.getSignFlag())) {
            contractDto.setSignFlag("1");
        } else {
            contractDto.setSignFlag(loanApplyContractDto.getSignFlag());
        }
        if (StringUtils.isEmpty((String)loanApplyContractDto.getNoticeDebtor())) {
            contractDto.setNoticeDebtor("1");
        } else {
            contractDto.setNoticeDebtor(loanApplyContractDto.getNoticeDebtor());
        }
        if (StringUtils.isEmpty((String)loanApplyContractDto.getNoticeDebtor())) {
            contractDto.setNoticeDebtor("1");
        } else {
            contractDto.setNoticeDebtor(loanApplyContractDto.getNoticeDebtor());
        }
        if (StringUtils.isEmpty((String)loanApplyContractDto.getSignStatus())) {
            contractDto.setSignStatus("1");
        } else {
            contractDto.setSignStatus(loanApplyContractDto.getSignStatus());
        }
        contractDto.setLoanContContent(this.getOSSFileByFileUrl(loanApplyContractDto.getLoanContContentOSSFileUrl()));
        if (StringUtils.isEmpty((String)loanApplyContractDto.getReplaceCollectAgrOSSFileUrl())) {
            log.warn("\u4ee3\u6536\u534f\u8bae\u5408\u540c\u5185\u5bb9-oss\u5730\u5740 \u5730\u5740\u4e3a\u7a7a");
            contractDto.setReplaceCollectAgr("\u4ee3\u6263\u534f\u8bae\u4e3a\u7a7a,\u6682\u65f6\u65e0\u6cd5\u63d0\u4f9b");
        } else {
            contractDto.setReplaceCollectAgr(this.getOSSFileByFileUrl(loanApplyContractDto.getReplaceCollectAgrOSSFileUrl()));
        }
        contractDto.setSigner(loanApplyContractDto.getSigner());
        contractDto.setSignerIdentNo(loanApplyContractDto.getSignerIdentNo());
        contractDto.setSignTime(loanApplyContractDto.getSignTime());
        contractDto.setAddress(loanApplyContractDto.getAddress());
        contractDto.setDn(loanApplyContractDto.getDn());
        HashMap<String, String> originDataMap = new HashMap<String, String>();
        originDataMap.put("\u8d37\u6b3e\u7533\u8bf7\u7f16\u53f7", loanApplyRequest.getOutApplyNo());
        originDataMap.put("\u5ba2\u6237\u53f7", dbAbcInitEnterpriseInfo.getClientCode());
        originDataMap.put("\u64cd\u4f5c\u5458\u8eab\u4efd\u8bc1\u53f7", loanApplyContractDto.getSignerIdentNo());
        originDataMap.put("\u7b7e\u7ea6\u65f6\u95f4", loanApplyContractDto.getSignTime());
        originDataMap.put("\u6838\u5fc3\u4f01\u4e1a\u540d\u79f0", loanApplyRequest.getCoreEntName());
        originDataMap.put("\u5ba2\u6237\u540d\u79f0", loanApplyRequest.getEntName());
        originDataMap.put("\u501f\u6b3e\u91d1\u989d", loanApplyRequest.getExpectLoanAmt().toString());
        originDataMap.put("\u501f\u6b3e\u671f\u9650", loanApplyRequest.getApplyEndDate());
        contractDto.setOriginData(JSON.toJSONString(originDataMap));
        return contractDto;
    }

    AdminNotifyDomain baseAdminNotifyDomain() {
        AdminNotifyDomain adminNotifyDomain = new AdminNotifyDomain();
        adminNotifyDomain.setProductId("");
        adminNotifyDomain.setBusiGroupCode("");
        adminNotifyDomain.setSysCode("");
        return adminNotifyDomain;
    }

    EntProductInfo getEntProductInfo() {
        EntProductInfo entProductInfo = new EntProductInfo();
        entProductInfo.setSrcId("001100");
        entProductInfo.setCoopYear("");
        entProductInfo.setRegisterAge("5");
        entProductInfo.setRelWithCoreEnt("11");
        entProductInfo.setTransAmt(new BigDecimal("150000000"));
        entProductInfo.setEvaluation("");
        entProductInfo.setEntLevel("1");
        ArrayList entSpecialInfoList = Lists.newArrayList();
        entSpecialInfoList.add(this.getEntSpecialInfo());
        entProductInfo.setEntProdFileInfoList((List)entSpecialInfoList);
        return entProductInfo;
    }

    EntSpecialInfo getEntSpecialInfo() {
        EntSpecialInfo entSpecialInfo = new EntSpecialInfo();
        return entSpecialInfo;
    }

    String getABCApi(String serviceId, InitReqDomain initReqDomain) {
        ABCApi.init((String)this.abcConfig.getKey(), (String)this.abcConfig.getAddress());
        return ABCApi.send((String)serviceId, (Object[])new Object[]{initReqDomain});
    }
}

