/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.cib;

import com.xforceplus.finance.dvas.common.service.cib.config.Configure;
import com.xforceplus.finance.dvas.common.service.cib.config.KeyConfigure;
import com.xforceplus.finance.dvas.common.service.cib.enums.ReqMethodEnum;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkExType;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkException;
import com.xforceplus.finance.dvas.common.service.cib.service.AbstractTransService;
import com.xforceplus.finance.dvas.common.service.cib.util.FileUtil;
import com.xforceplus.finance.dvas.common.service.cib.util.SdkUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class OpenSdk {
    private static final String FILE_ID = "fileId";
    private static final String ALGORITHM = "SHA-1";
    private static final String FILE_HASH_VALUE = "fileHashValue";

    public static String gateway(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, Map<String, String> bodyParams) {
        try {
            Object result = AbstractTransService.getInstance().exec(reqUri, reqMethod, headParams, urlParams, bodyParams, null, Configure.getKeyConfigure(), null);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static String gatewayWithKeyId(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, Map<String, String> bodyParams, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            Object result = AbstractTransService.getInstance().exec(reqUri, reqMethod, headParams, urlParams, bodyParams, null, keyConfigure, null);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static String gatewayJsonWithKeyId(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, String bodyJson, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            if (!SdkUtil.isJSONString(bodyJson)) {
                return new SdkException(SdkExType.PARAM_ERR).toString();
            }
            Object result = AbstractTransService.getInstance().exec(reqUri, reqMethod, headParams, urlParams, null, null, keyConfigure, bodyJson);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static String gatewayNetSignWithKeyId(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, Map<String, String> bodyParams, String bodyJson, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            Object result = AbstractTransService.getInstance().execNetSign(reqUri, reqMethod, null, null, bodyParams, null, keyConfigure, bodyJson);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static Object downloadFile(String fileId) {
        try {
            HashMap<String, String> urlParams = new HashMap<String, String>(8);
            urlParams.put(FILE_ID, fileId);
            Object result = AbstractTransService.getInstance().exec("/api/open/downloadFile", ReqMethodEnum.GET, null, urlParams, null, null, Configure.getKeyConfigure(), null);
            return result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static Object downloadFileWithKeyId(String fileId, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            HashMap<String, String> urlParams = new HashMap<String, String>(8);
            urlParams.put(FILE_ID, fileId);
            Object result = AbstractTransService.getInstance().exec("/api/open/downloadFile", ReqMethodEnum.GET, null, urlParams, null, null, keyConfigure, null);
            return result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String downloadFile(String fileId, String filePath) {
        try {
            HashMap<String, String> urlParams = new HashMap<String, String>(8);
            urlParams.put(FILE_ID, fileId);
            Object result = AbstractTransService.getInstance().exec("/api/open/downloadFile", ReqMethodEnum.GET, null, urlParams, null, null, Configure.getKeyConfigure(), null);
            if (!(result instanceof byte[])) return (String)result;
            FileOutputStream fos = null;
            try {
                File file22 = new File(filePath);
                fos = new FileOutputStream(file22);
                fos.write((byte[])result);
                return "{\"code\":\"OPEN25800\",\"msg\":\"\u4e0b\u8f7d\u6210\u529f\",\"traceId\":\"OPEN-00-LOCAL-800\"}";
            }
            catch (Exception e) {
                SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
                String string = ex.toString();
                return string;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e2) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String downloadFileWithKeyId(String fileId, String filePath, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            HashMap<String, String> urlParams = new HashMap<String, String>(8);
            urlParams.put(FILE_ID, fileId);
            Object result = AbstractTransService.getInstance().exec("/api/open/downloadFile", ReqMethodEnum.GET, null, urlParams, null, null, keyConfigure, null);
            if (!(result instanceof byte[])) return (String)result;
            FileOutputStream fos = null;
            try {
                File file22 = new File(filePath);
                fos = new FileOutputStream(file22);
                fos.write((byte[])result);
                return "{\"code\":\"OPEN25800\",\"msg\":\"\u4e0b\u8f7d\u6210\u529f\",\"traceId\":\"OPEN-00-LOCAL-800\"}";
            }
            catch (Exception e) {
                SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
                String string = ex.toString();
                return string;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e2) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static String uploadFile(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
                return ex.toString();
            }
            String fileHashValue = FileUtil.fileHash(filePath, ALGORITHM);
            HashMap<String, String> bodyParams = new HashMap<String, String>(8);
            bodyParams.put(FILE_HASH_VALUE, fileHashValue);
            Object result = AbstractTransService.getInstance().exec("/api/open/uploadFile", ReqMethodEnum.POST, null, null, bodyParams, filePath, Configure.getKeyConfigure(), null);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }

    public static String uploadFileWithKeyId(String filePath, String keyId) {
        try {
            KeyConfigure keyConfigure = Configure.getKeyConfigures().get(keyId);
            if (null == keyConfigure) {
                return new SdkException(SdkExType.KEY_CONFIGURE_ERR).toString();
            }
            File file = new File(filePath);
            if (!file.exists()) {
                SdkException ex = new SdkException(SdkExType.FILE_ERROR_RESULT);
                return ex.toString();
            }
            String fileHashValue = FileUtil.fileHash(filePath, ALGORITHM);
            HashMap<String, String> bodyParams = new HashMap<String, String>(8);
            bodyParams.put(FILE_HASH_VALUE, fileHashValue);
            Object result = AbstractTransService.getInstance().exec("/api/open/uploadFile", ReqMethodEnum.POST, null, null, bodyParams, filePath, keyConfigure, null);
            return (String)result;
        }
        catch (Exception e) {
            SdkException ex = new SdkException(SdkExType.UNKNOWN);
            return ex.toString();
        }
    }
}

