/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.cib.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.finance.dvas.common.service.cib.config.Configure;
import com.xforceplus.finance.dvas.common.service.cib.config.KeyConfigure;
import com.xforceplus.finance.dvas.common.service.cib.enums.KeySignTypeEnum;
import com.xforceplus.finance.dvas.common.service.cib.enums.ReqMethodEnum;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkExType;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkException;
import com.xforceplus.finance.dvas.common.service.cib.util.Base64;
import com.xforceplus.finance.dvas.common.service.cib.util.SdkUtil;
import com.xforceplus.finance.dvas.common.service.cib.util.Signature;
import com.xforceplus.finance.dvas.common.service.cib.util.SymmetricEncrypt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractTransService {
    public abstract Object send(String var1, ReqMethodEnum var2, String var3, Map<String, String> var4, String var5, String var6, Map<String, String> var7, KeyConfigure var8, String var9) throws Exception;

    public static AbstractTransService getInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = Class.forName(Configure.getHttpsRequestClassName());
        return (AbstractTransService)c.newInstance();
    }

    protected static Object txn(String url, ReqMethodEnum method, String authInfo, Map<String, String> headParams, String bodyParamString, String filePath, Map<String, String> bodyParamMap, KeyConfigure keyConfigure, String bodyJson) throws SdkException {
        Object resp = null;
        try {
            AbstractTransService transService = AbstractTransService.getInstance();
            resp = transService.send(url, method, authInfo, headParams, bodyParamString, filePath, bodyParamMap, keyConfigure, bodyJson);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw new SdkException(SdkExType.CONN_ERR);
            }
            if (e instanceof SdkException) {
                throw (SdkException)e;
            }
            throw new SdkException(SdkExType.UNKNOWN);
        }
        return resp;
    }

    protected String getPostUrl() {
        String url = Configure.isDevEnv() ? Configure.getDevUrl() : "https://open.cibfintech.com";
        return SdkUtil.notBlank(url) && url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    protected String getAuthInfo(ReqMethodEnum method, String uri, Map<String, String> signParams, KeyConfigure keyConfigure) {
        String timestamp = SdkUtil.getDateTime();
        String nonce = UUID.randomUUID().toString().replaceAll("-", "");
        StringBuilder builder = new StringBuilder();
        builder.append(keyConfigure.getKeyId());
        builder.append("&");
        builder.append(timestamp);
        builder.append("&");
        builder.append(nonce);
        builder.append("&");
        builder.append((Object)method);
        builder.append("&");
        builder.append(uri);
        if (signParams != null && signParams.size() != 0) {
            ArrayList<String> keyList = new ArrayList<String>(signParams.keySet());
            Collections.sort(keyList);
            for (String key : keyList) {
                builder.append("&");
                builder.append(key);
                builder.append("=");
                builder.append(signParams.get(key));
            }
        }
        String user = keyConfigure.getKeyId() + "_" + timestamp + "_" + nonce;
        String pwd = KeySignTypeEnum.SHA256WITHRSA.equals((Object)keyConfigure.getKeySignType()) ? Signature.signatureByRSA(builder.toString(), keyConfigure.getPriKey(), "UTF-8") : Signature.signatureBySM2(builder.toString(), keyConfigure.getPriKey(), "UTF-8");
        return "Basic " + Base64.encode((user + ":" + pwd).getBytes());
    }

    protected String getNetSignAuthInfo(ReqMethodEnum method, String uri, String commKey, Map<String, String> signParams, KeyConfigure keyConfigure) throws Exception {
        String timestamp = SdkUtil.getDateTime();
        String nonce = UUID.randomUUID().toString().replaceAll("-", "");
        StringBuilder builder = new StringBuilder();
        builder.append(keyConfigure.getKeyId());
        builder.append("&");
        builder.append(timestamp);
        builder.append("&");
        builder.append(nonce);
        builder.append("&");
        builder.append((Object)method);
        builder.append("&");
        builder.append(uri);
        builder.append("&");
        builder.append(commKey);
        if (signParams != null && signParams.size() != 0) {
            ArrayList<String> keyList = new ArrayList<String>(signParams.keySet());
            Collections.sort(keyList);
            for (String key : keyList) {
                builder.append("&");
                builder.append(key);
                builder.append("=");
                builder.append(signParams.get(key));
            }
        }
        String encCommKey = Signature.encryptBySM2PublicKey(keyConfigure.getRespPubKey(), commKey.getBytes(StandardCharsets.UTF_8));
        String user = keyConfigure.getKeyId() + "_" + timestamp + "_" + nonce + "_" + encCommKey;
        String pwd = KeySignTypeEnum.SHA256WITHRSA.equals((Object)keyConfigure.getKeySignType()) ? Signature.signatureByRSA(builder.toString(), keyConfigure.getPriKey(), "UTF-8") : Signature.signatureBySM2(builder.toString(), keyConfigure.getPriKey(), "UTF-8");
        return "Basic " + Base64.encode((user + ":" + pwd).getBytes());
    }

    public Map<String, String> getEncryptBody(Map<String, String> bodyParamMap, String commKey) throws SdkException {
        String bodyParamJsonString = JSON.toJSONString(bodyParamMap);
        HashMap<String, String> encryptBodyParamMap = new HashMap<String, String>(2);
        try {
            encryptBodyParamMap.put("ENC_DATA", SymmetricEncrypt.sm4Encrypt(bodyParamJsonString, commKey));
            return encryptBodyParamMap;
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.NET_SIGN_ERR);
        }
    }

    public Object exec(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, Map<String, String> bodyParamMap, String filePath, KeyConfigure keyConfigure, String bodyJson) {
        HashMap<String, String> signParams = new HashMap<String, String>(64);
        if (SdkUtil.notEmpty(headParams)) {
            signParams.putAll(headParams);
        }
        if (SdkUtil.notEmpty(urlParams)) {
            signParams.putAll(urlParams);
        }
        if (SdkUtil.notEmpty(bodyParamMap)) {
            signParams.putAll(bodyParamMap);
        }
        if (SdkUtil.isJSONString(bodyJson)) {
            signParams.put("BODY", bodyJson);
        }
        reqUri = SdkUtil.checkReqUri(reqUri);
        String authInfo = this.getAuthInfo(reqMethod, reqUri, signParams, keyConfigure);
        String urlParam = SdkUtil.jointMap(urlParams);
        String bodyParamString = SdkUtil.jointMap(bodyParamMap);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getPostUrl());
        urlBuilder.append(reqUri);
        switch (reqMethod) {
            case GET: 
            case POST: {
                if (!SdkUtil.notBlank(urlParam)) break;
                urlBuilder.append(urlBuilder.toString().contains("?") ? "&" : "?");
                urlBuilder.append(urlParam);
                break;
            }
        }
        Object response = "";
        try {
            response = AbstractTransService.txn(urlBuilder.toString(), reqMethod, authInfo, headParams, bodyParamString, filePath, bodyParamMap, keyConfigure, bodyJson);
        }
        catch (SdkException ex) {
            if (SdkExType.CONN_ERR.getCode().equals(ex.getCode())) {
                String url = Configure.isDevEnv() ? Configure.getDevUrl() : "https://open.cibfintech.com";
                response = ex.toString().replace("\u901a\u8baf\u9519\u8bef", url + "\u901a\u8baf\u9519\u8bef");
            }
            response = ex.toString();
        }
        return response;
    }

    public Object execNetSign(String reqUri, ReqMethodEnum reqMethod, Map<String, String> headParams, Map<String, String> urlParams, Map<String, String> bodyParamMap, String filePath, KeyConfigure keyConfigure, String bodyJson) throws Exception {
        String commKey = SymmetricEncrypt.generateSM4Key();
        HashMap<String, String> signParams = new HashMap<String, String>(64);
        if (SdkUtil.notEmpty(headParams)) {
            signParams.putAll(headParams);
        }
        if (SdkUtil.notEmpty(urlParams)) {
            signParams.putAll(urlParams);
        }
        if (SdkUtil.notEmpty(bodyParamMap)) {
            signParams.putAll(bodyParamMap);
        }
        if (SdkUtil.isJSONString(bodyJson)) {
            signParams.put("BODY", bodyJson);
        }
        reqUri = SdkUtil.checkReqUri(reqUri);
        String authInfo = this.getNetSignAuthInfo(reqMethod, reqUri, commKey, signParams, keyConfigure);
        Map<String, String> encryptBodyParamMap = this.getEncryptBody(bodyParamMap, commKey);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getPostUrl());
        urlBuilder.append(reqUri);
        String bodyParamString = SdkUtil.jointMap(encryptBodyParamMap);
        Object response = "";
        try {
            response = AbstractTransService.txn(urlBuilder.toString(), reqMethod, authInfo, null, bodyParamString, filePath, encryptBodyParamMap, keyConfigure, bodyJson);
            JSONObject responseObject = JSON.parseObject((String)((String)response));
            String encData = responseObject.getString("ENC_DATA");
            if (encData == null || encData.equals("")) {
                return response;
            }
            response = SymmetricEncrypt.sm4Decrypt(encData, commKey);
        }
        catch (SdkException ex) {
            if (SdkExType.CONN_ERR.getCode().equals(ex.getCode())) {
                String url = Configure.isDevEnv() ? Configure.getDevUrl() : "https://open.cibfintech.com";
                response = ex.toString().replace("\u901a\u8baf\u9519\u8bef", url + "\u901a\u8baf\u9519\u8bef");
            }
            response = ex.toString();
        }
        return response;
    }
}

