/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.cib.util;

import com.xforceplus.finance.dvas.common.service.cib.exception.SdkExType;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkException;
import com.xforceplus.finance.dvas.common.service.cib.util.Base64;
import com.xforceplus.finance.dvas.common.service.cib.util.SdkUtil;
import com.xforceplus.finance.dvas.common.service.cib.util.Signature;
import com.xforceplus.finance.dvas.common.service.cib.util.SymmetricEncrypt;
import com.xforceplus.finance.dvas.common.service.cib.util.VerifyRespSignature;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class CallbackUtil {
    public static String decryptAndVerify(String keyId, String timestamp, String nonce, String signValue, String body, String decryptKey, String publicKey) throws SdkException {
        String decryptedBody;
        block6: {
            try {
                decryptedBody = SymmetricEncrypt.sm4Decrypt(body, decryptKey);
            }
            catch (Exception e) {
                throw new SdkException(SdkExType.CALLBACK_BODY_ENCRYPT_ERR);
            }
            if (SdkUtil.notBlank(signValue)) {
                StringBuilder signParams = new StringBuilder().append(keyId).append("&").append(timestamp).append("&").append(nonce).append("&").append(decryptedBody);
                try {
                    byte[] bytes = signParams.toString().getBytes("UTF-8");
                    if (!VerifyRespSignature.verifyBySM2(bytes, signValue, publicKey)) {
                        throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
                }
            }
            throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
        }
        return decryptedBody;
    }

    public static Map<String, String> decryptAndVerifyV2(String keyId, String timestamp, String nonce, String pwd, String signValue, String body, String priKey, String respPubKey) throws SdkException {
        String decryptedBody;
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        try {
            byte[] pwdByte = Signature.decryptBySM2PrivateKey(priKey, Base64.decode(pwd));
            assert (pwdByte != null);
            pwd = new String(pwdByte, StandardCharsets.UTF_8);
            resultMap.put("pwd", pwd);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.CALLBACK_BODY_ENCRYPT_ERR);
        }
        try {
            decryptedBody = SymmetricEncrypt.sm4Decrypt(body, pwd);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.CALLBACK_BODY_ENCRYPT_ERR);
        }
        if (SdkUtil.notBlank(signValue)) {
            StringBuilder signParams = new StringBuilder().append(keyId).append("&").append(timestamp).append("&").append(nonce).append("&").append(pwd).append("&").append(decryptedBody);
            try {
                byte[] bytes = signParams.toString().getBytes("UTF-8");
                if (!VerifyRespSignature.verifyBySM2(bytes, signValue, respPubKey)) {
                    throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
                }
                resultMap.put("body", decryptedBody);
            }
            catch (Exception e) {
                throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
            }
        } else {
            throw new SdkException(SdkExType.CALLBACK_REQUEST_VERIFY_ERR);
        }
        return resultMap;
    }

    public static String signature(String keyId, String timestamp, String nonce, String body, String privateKey) throws SdkException {
        if (!(SdkUtil.notBlank(keyId) && SdkUtil.notBlank(timestamp) && SdkUtil.notBlank(nonce) && SdkUtil.notBlank(body))) {
            throw new SdkException(SdkExType.CALLBACK_RESPONSE_SIGN_ERR);
        }
        StringBuilder signParams = new StringBuilder().append(keyId).append("&").append(timestamp).append("&").append(nonce).append("&").append(body);
        return Signature.signatureBySM2(signParams.toString(), privateKey, "UTF-8");
    }

    public static String encrypt(String body, String encryptKey) throws SdkException {
        String encryptedBody;
        try {
            encryptedBody = SymmetricEncrypt.sm4Encrypt(body, encryptKey);
        }
        catch (Exception e) {
            throw new SdkException(SdkExType.CALLBACK_BODY_ENCRYPT_ERR);
        }
        return encryptedBody;
    }
}

