/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.cib.util;

import com.xforceplus.finance.dvas.common.service.cib.util.Base64;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class Signature {
    private static final BouncyCastleProvider BC = new BouncyCastleProvider();
    private static final int RS_LEN = 32;
    private static final String ALGORITHM_EC = "EC";
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());

    public static String signatureByRSA(String content, String privateKey, String charset) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            java.security.Signature signature = java.security.Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(content.getBytes(charset));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String signatureBySM2(String content, String privateKey, String charset) {
        byte[] privateKeyBytes = Base64.decode(privateKey);
        BCECPrivateKey bcecPrivateKey = Signature.getPrivateKeyFromD(BigIntegers.fromUnsignedByteArray((byte[])privateKeyBytes));
        try {
            byte[] contentBytes = content.getBytes(charset);
            byte[] signed = Signature.rsAsn1ToPlainByteArray(Signature.signSm3WithSm2Asn1Rs(contentBytes, (PrivateKey)bcecPrivateKey));
            return Base64.encode(signed);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptBySM2PublicKey(String encodedPublicKey, byte[] contentBytes) throws Exception {
        BigInteger y;
        BigInteger x;
        byte[] publicKeyBytes = Base64.decode(encodedPublicKey);
        if (publicKeyBytes.length != 64 && publicKeyBytes.length != 65) {
            throw new Exception("err key length");
        }
        if (publicKeyBytes.length > 64) {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)1, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)33, (int)32);
        } else {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)0, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)32, (int)32);
        }
        BCECPublicKey bcecPublicKey = Signature.getPublicKeyFromXY(x, y);
        byte[] results = Signature.changeC1C2C3ToC1C3C2(Signature.encryptBySM2PublicKeyOld(contentBytes, bcecPublicKey));
        return Base64.encode(results);
    }

    public static byte[] decryptBySM2PrivateKey(String encodedPrivateKey, byte[] contentBytes) throws Exception {
        try {
            byte[] privateKeyBytes = Base64.decode(encodedPrivateKey);
            BCECPrivateKey bcecPrivateKey = Signature.getPrivateKeyFromD(BigIntegers.fromUnsignedByteArray((byte[])privateKeyBytes));
            return Signature.decryptBySM2PrivateKeyOld(Signature.changeC1C3C2ToC1C2C3(contentBytes), bcecPrivateKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decryptBySM2PrivateKeyOld(byte[] data, BCECPrivateKey bcecPrivateKey) throws InvalidCipherTextException {
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(bcecPrivateKey.getD(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        return sm2Engine.processBlock(data, 0, data.length);
    }

    private static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2) {
        int c1Len = (x9ECParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static byte[] encryptBySM2PublicKeyOld(byte[] data, BCECPublicKey bcecPublicKey) throws InvalidCipherTextException {
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(bcecPublicKey.getQ(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        return sm2Engine.processBlock(data, 0, data.length);
    }

    private static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3) {
        int c1Len = (x9ECParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    private static BCECPrivateKey getPrivateKeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey(ALGORITHM_EC, ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static BCECPublicKey getPublicKeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey(ALGORITHM_EC, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    private static byte[] bigIntToFixedLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange(rs, 1, 33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill(result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    private static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = Signature.bigIntToFixedLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = Signature.bigIntToFixedLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] signSm3WithSm2Asn1Rs(byte[] msg, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        java.security.Signature signer = java.security.Signature.getInstance("SM3WithSM2", (Provider)BC);
        signer.initSign(privateKey, new SecureRandom());
        signer.update(msg, 0, msg.length);
        byte[] sig = signer.sign();
        return sig;
    }
}

