/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.cib.util;

import com.xforceplus.finance.dvas.common.service.cib.config.KeyConfigure;
import com.xforceplus.finance.dvas.common.service.cib.enums.RespSignAlgorithmEnum;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkExType;
import com.xforceplus.finance.dvas.common.service.cib.exception.SdkException;
import com.xforceplus.finance.dvas.common.service.cib.util.Base64;
import com.xforceplus.finance.dvas.common.service.cib.util.SdkUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.BigIntegers;
import sun.misc.BASE64Decoder;

public class VerifyRespSignature {
    private static final BouncyCastleProvider BC = new BouncyCastleProvider();
    private static final int RS_LEN = 32;
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());

    public static void verify(String timestamp, String nonce, String responseSignValue, Object retn, KeyConfigure keyConfigure) throws SdkException {
        block6: {
            if (SdkUtil.notBlank(timestamp) && SdkUtil.notBlank(responseSignValue)) {
                try {
                    byte[] bodyContentBytes;
                    String respPubKey = keyConfigure.getRespPubKey();
                    String verifyAlgorithm = keyConfigure.getRespSignAlgorithm().getLabel();
                    if (retn instanceof String) {
                        String content = (String)retn;
                        bodyContentBytes = content.getBytes("UTF-8");
                    } else {
                        bodyContentBytes = (byte[])retn;
                    }
                    byte[] timestampBytes = timestamp.getBytes("UTF-8");
                    byte[] nonceBytes = nonce.getBytes("UTF-8");
                    byte[] contentBytes = new byte[timestampBytes.length + nonceBytes.length + bodyContentBytes.length];
                    System.arraycopy(timestampBytes, 0, contentBytes, 0, timestampBytes.length);
                    System.arraycopy(nonceBytes, 0, contentBytes, timestampBytes.length, nonceBytes.length);
                    System.arraycopy(bodyContentBytes, 0, contentBytes, timestampBytes.length + nonceBytes.length, bodyContentBytes.length);
                    boolean flag = RespSignAlgorithmEnum.SM3WITHSM2.equals((Object)keyConfigure.getRespSignAlgorithm()) ? VerifyRespSignature.verifyBySM2(contentBytes, responseSignValue, respPubKey) : VerifyRespSignature.verifyByRSA(contentBytes, responseSignValue, respPubKey, verifyAlgorithm);
                    if (!flag) {
                        throw new SdkException(SdkExType.RESPONSE_SIGN_ERR);
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new SdkException(SdkExType.RESPONSE_SIGN_ERR);
                }
            }
            throw new SdkException(SdkExType.RESPONSE_SIGN_ERR);
        }
    }

    private static boolean verifyByRSA(byte[] contentBytes, String sign, String publicKey, String verifyAlgorithm) {
        try {
            byte[] b = new BASE64Decoder().decodeBuffer(publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(b);
            KeyFactory factoty = KeyFactory.getInstance("RSA");
            PublicKey pubKey = factoty.generatePublic(keySpec);
            Signature signature = Signature.getInstance(verifyAlgorithm);
            signature.initVerify(pubKey);
            signature.update(contentBytes);
            return signature.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verifyBySM2(byte[] contentBytes, String sign, String publicKey) {
        BigInteger y;
        BigInteger x;
        byte[] publicKeyBytes = Base64.decode(publicKey);
        if (publicKeyBytes.length != 64 && publicKeyBytes.length != 65) {
            return false;
        }
        if (publicKeyBytes.length > 64) {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)1, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)33, (int)32);
        } else {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)0, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)32, (int)32);
        }
        BCECPublicKey bcecPublicKey = VerifyRespSignature.getPublicKeyFromXY(x, y);
        byte[] rs = Base64.decode(sign);
        return VerifyRespSignature.verifySm3WithSm2Asn1Rs(contentBytes, VerifyRespSignature.rsPlainByteArrayToAsn1(rs), (PublicKey)bcecPublicKey);
    }

    private static BCECPublicKey getPublicKeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(sign, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(sign, 32, 64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean verifySm3WithSm2Asn1Rs(byte[] msg, byte[] rs, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance("SM3WithSM2", (Provider)BC);
            signature.initVerify(publicKey);
            signature.update(msg, 0, msg.length);
            return signature.verify(rs);
        }
        catch (Exception e) {
            return false;
        }
    }
}

